<?PHP
/**
* Die Klasse stellt dynamische Seitenzahlen dar
*
* @version 0.3.1 05.12.2003 19:50
*/
class no_seiten_zahlen {
/**
* Gesamtzahl aller Seiten
*
* @access private
* @since 0.1     
* @var int $seiten_gesamt 
*/
  var $seiten_gesamt = 5;
/**
* Anzahl der in der Auswahl angezeigtenm Seitenzahlen
*
* @access private
* @since 0.1     
* @var int $seiten_angezeigt 
*/
  var $seiten_angezeigt = 5;
/**
* Ein Feld, das den vor- und nach-? Teil enthlt (URL/QUERY)
*
* @access private
* @since 0.1     
* @var array $link_url 
*/
  var $link_url = array("", "dszi");
/**
* Diese Feld enthlt die Indizies fr die Flle, da die Seitenzahl nicht mit der ID des 
* aufgerufenen Eintags bereinstimmt 
*
* @access private
* @since 0.2     
* @var int $substitution 
*/
  var $substitution = array();
/**
* CSS-Klasse der aktiven Seitenzahl
*
* @access private
* @since 0.3     
* @var string $class_aktiv 
*/
  var $class_aktiv = "";
/**
* CSS-Klasse der inaktiven Seitenzahlen
*
* @access private
* @since 0.3     
* @var string $class_inaktiv 
*/
  var $class_inaktiv = "";
/**
* CSS-Stylez der aktiven Seitenzahl
*
* @access private
* @since 0.3     
* @var string $style_aktiv 
*/
  var $style_aktiv = "";
/**
* CSS-Stylez der inaktiven Seitenzahlen
*
* @access private
* @since 0.3     
* @var string $style_inaktiv 
*/
  var $style_inaktiv = "";
/**
* Setzt die CSS-Style Eigenschaften der aktiven bzw. erreichbaren Seiten
*
* Die Zahlen sind jeweils in ein <span> gekapselt, der Style/die Class der  
* enthaltenen Links kann nicht direkt gesetzt werden. Um die zu formatieren, 
* mu dem <span> eine CSS-Klasse zugewiesen werden, 
* und der Link dann per .classname a {} formatiert werden ....
*
* @access public 
* @param string $aktiv Style der aktuellen Seitenzahl   
* @param string $inaktiv Style der restlichen Seitenzahlen
* @return void
* @see set_css_classes()
* @since 0.3     
*/
  function set_css_stylez ($aktiv = "", $inaktiv = "") {
    $this->style_aktiv = $aktiv;
    $this->style_inaktiv = $inaktiv;
  }
/**
* Setzt die CSS-Klassen der aktiven bzw. erreichbaren Seiten
*
* Hiermit knnen den Bereichen direkt CSS-Klassen zugewiesen werden
*
* @access public 
* @param string $aktiv Klasse der aktuellen Seitenzahl   
* @param string $inaktiv Klasse der restlichen Seitenzahlen   
* @return void
* @see set_css_stylez()
* @since 0.3     
*/
  function set_css_classes ($aktiv = "", $inaktiv = "") {
    $this->class_aktiv = $aktiv;
    $this->class_inaktiv = $inaktiv;
  }
/**
* Setzt den Link, der bei Anklicken einer Seitenzahl aufgerufen werden soll
*
* Achtung: Hierbei knnen schon leichte Gehirn-Verknotungen auftreten.
* Die einfachste Form der bergebenen URL knnte "?seite=dszi" sein, 
* wobei 'dszi' (der_seiten_zahlen_index, ll) als platzhalter fr 
* die jeweilige Seitenzahl gilt
*
* @access public 
* @param string $url Die URL halt (mit Platzhalter!!! name = 'dszi')   
* @return void
* @since 0.1     
*/
  function set_url ($url = "?") {
    $this->link_url = explode ("?", $url, 2);
  }
/**
* Legt die Gesamtanzahl der Seiten und die Anzahl der angezeigten fest
*
* Es fehlen (wie berall) die Sicherheitsberprfungen, so handle with care  
*
* @access public 
* @param int $seiten_gesamt Anzahl aller vorhandenen Seiten   
* @param int $seiten_angezeigt Anzahl der Seitenzahlen, die angezeigt werden sollen  
* @return void
* @since 0.1     
*/
  function set_params ($seiten_gesamt = 5, $seiten_angezeigt = 5) {
    $this->seiten_gesamt = $seiten_gesamt;
    $this->seiten_angezeigt = $seiten_angezeigt;
  }
/**
* Erlaubt das nicht-lineare?? Ansprechen von Seiten  
*
* Fr die Flle, in denen sich der angesprochen Index von der Seitenzahl 
* unterscheiden sollte, kann hiermit ein Feld aufgebaut werden, welches als
* Index die Seitenzahl trgt, als Inhalt die Verweis_ID (oder irgendwas) hat ...
* Hier werden alle Index einzeln in des Feld gepusht, von mir aus inner while () {}
*
* @access public 
* @param int $sub ID der Seite  
* @return void
* @since 0.2     
*/
  function add_subst ($sub) {
    array_push ($this->substitution, $sub);
  }
/**
* Erlaubt das nicht-lineare?? Ansprechen von Seiten  
*
* Fr die Flle, in denen sich der angesprochen Index von der Seitenzahl 
* unterscheiden sollte, kann hiermit ein Feld aufgebaut werden, welches als
* Index die Seitenzahl trgt, als Inhalt die Verweis_ID (oder irgendwas) hat ...
* Hier wird das gesamte Feld bergeben, es sollte also vorher aufgebaut werden ...
*
* @access public 
* @param array $subst Feld mit allen IDs  
* @return void
* @since 0.3     
*/
  function set_subst ($subs) {
    if (is_array($subs))
      $this->substitution = $subs;
  }
/**
* Gibt die Seitenzahlen aus ...  
*
* Hier erfolgt die Ausgabe. In Fllen, bei denen set_params() sehr kleine Werte erhlt, 
* knnten komische Sachen passieren ... mssen aber nicht  
*
* @access public 
* @param int $aktive_seite  
* @return string 
* @since 0.1     
*/
  function get ($aktive_seite) {
    $output = "";
    if (sizeof($this->substitution) > 0)
      for ($index = 0; $index < sizeof($this->substitution); $index++)
        if ($this->substitution[$index] == $aktive_seite)
          $aktive_seite = $index + 1;   
    if (($linke_grenze = $aktive_seite - round($this->seiten_angezeigt / 2) + 1) < 1) 
      $linke_grenze = 1;
    if (($rechte_grenze = $linke_grenze + $this->seiten_angezeigt) > $this->seiten_gesamt) {
      $rechte_grenze = $this->seiten_gesamt + 1;
      $linke_grenze  = ($this->seiten_gesamt >= $this->seiten_angezeigt)
        ? $rechte_grenze - $this->seiten_angezeigt
        : 1;
    }
    for ($index = $linke_grenze; $index < $rechte_grenze; $index++) {
      if ($index == $aktive_seite) 
        $output .= " <span class=\"".$this->class_aktiv."\" style=\"".$this->style_aktiv."\">[".$index."]</span> ";
      else {
        $output .= " <span class=\"".$this->class_inaktiv."\" style=\"".$this->style_inaktiv."\"><a href=\"";
        $output .= ($this->link_url[0] != "")
          ? $this->link_url[0]
          : $_SERVER["PHP_SELF"];
        $output .= "?".preg_replace("/dszi/i", ((sizeof($this->substitution) > 0) ? $this->substitution[$index - 1] : $index), $this->link_url[1])."\"> ";

        if ($index == $linke_grenze && $index != 1) $output .= "&laquo;";
        elseif ($index == $rechte_grenze - 1 && $index != $this->seiten_gesamt) $output .= "&raquo;";
        else $output .= $index;
        
        $output .= "</a></span> ";
      }
    }
    return $output;
  }
}
?>