<?php
/*******************************************************************************************************
Backup_all
Copyright (c) 2004 by George Ruinelli
mehr infos in info.txt

Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation verffentlicht, weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder (nach Ihrer Option) jeder spteren Version.

Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

Sie sollten eine Kopie der GNU General Public License zusammen mit diesem Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 

******************************************************************************************************/



//error_reporting(1);  //nur errors ausgeben
//error_reporting(E_ALL); //alle Meldungen anzeigen (fr Debug)


include("funktionen.php");
include("tar.class.php");


$datum=  date("d_m_Y__H-i");
$filename = "Backup_von_".$_SERVER["HTTP_HOST"]."_vom_".$datum.".tar.gz";   //Namen des Back

$format_positiv="<font color=\"#000000\"  size=\"-5\">";
$format_negativ="<font color=\"#FF0000\"  size=\"-5\">";


//Verwendete Variablen:
$dateien_total=0;
$dateien_gesichert=0;
$dateien_ausgeschlossen=0;

$groesse_total=0; //Groesse von ALLEN Dateien
$groesse_gesichert=0; //Groesse von den gesicherten Dateien
$groesse_ausgeschlossen=0; //Groesse von den ausgeschlossenen Dateien

$groesse_komprimiert=0; //Groesse von den gesicherten und komprimierten Dateien

//Arrays erstellen
$array_files = array();
$array_files_unlesbar = array();
$array_exclude = array();

// Create instance of TAR class
$tar = new tar();



$startzeit=getmicrotime();


//Status-Datei leeren
$fs = fopen ("status.htm", "w");
  write_log("");
fclose ($fs);


if($komprimierung=="")$komprimierung=true;



///////////// START ///////////////////////////////////
$array_exclude=split ( ",", $exclude);




$fs = fopen ("status.htm", "w");
write_log("<h2>Erstelle Backup des ganzen Webspaces</h2><p>Startzeit: ".date("d.m.Y  H:i")."<br>");   
write_log("Die gz-Komprimierung der Backup-Datei wurde "); 

if($komprimierung=="false")
  write_log("Deaktiviert<br>");    
else
  write_log("Aktiviert<br>");          
     
write_log("Dateien oder Ordner mit folgenden Wortfragmenten werden <b>nicht</b> gesichert:<br><i>");

foreach ($array_exclude as $value) { 
  write_log("-$value<br>\n");
} 
write_log("</i><br>\n<br>\n");

write_log("$format_positiv<br>\n");  




if($basedir==""){
    write_log("</p><h2><font color=\"#ff0000\" size=\"-5\">Es wurde kein Startverzeichnis angegeben, der Script wird beendent.</b></font></h2>"); 
    exit();
}

write_log("Die Liste der zu sichernden Dateien wird erstellt...<br>\n");  
listfiles($basedir);

if (count($array_files_unlesbar)!=0){
  write_log("<br>\n</font>".$format_negativ.
           "ACHTUNG:<br>
            Folgende Dateien oder der Ordner (inkl. den darin liegenden Dateien und Ordner) k&ouml;nnen nicht gelesen werden (Permission denied)
           und werden vom Backup ausgeschlossen:<br>\n");
  foreach ($array_files_unlesbar as $value) { 
    $name=str_replace($basedir, "", $value);
    write_log("-$name<br>\n");  
  }
  write_log("</font><br>\n".$format_positiv);
}


$dateien_total=count($array_files);

$groesse_total=$groesse_total/1024/1024;  //in MB wandeln
$groesse_total=substr( $groesse_total, 0 , 5);  //Nachkomastellen kuerzen
write_log("Es sollen total $groesse_total MB in $dateien_total Dateien 
(inkl. der im Formular ausgew&auml;hlten auszuschliessenden Dateien) gesichert werden.<br>\n<br>\n");  

/*DEBUG:
foreach ($array_files as $value) {
    $x=str_replace($basedir,"",$value[0]);
    echo $x."_______________________".$value[1]."<br>\n";
}*/








write_log("Die Dateien werden eingelesen und dem Backup hinzugef&uuml;gt...<br>\n<br>\n");  
//Alle Dateien abarbeiten
while(list($k, $v) = each($array_files)){

    @set_time_limit(30);        //Timeout-Zeit rcksetzen  @ fr keine warnung
    
    $name=str_replace($basedir, "", $v[0]);  //Basispfad wegkuerzen

    //Auszuschliessende Dateien filtern   
    $ausschliessen=false;     
    foreach ($array_exclude as $value) { 
       if($value!=""){
          $pos=substr_count($name, trim($value));
          if($pos!=0)$ausschliessen=true;
       }
    }              
         
         $file_groesse=$v[2];
         $groesse_total+=$file_groesse;
         $file_groesse_kb=(int)($file_groesse/1024);
         
          
         if($ausschliessen==false) 
         {   
             //Datei einlesen
             //echo "debugging ($x): ". $v[0] ."<br>";             
             $groesse_gesichert+=$file_groesse;            
             $success=$tar->addFile( $v[0],$name);    //Datei dem Tar hinzufuegen
             if($success==TRUE){
                $dateien_gesichert++;
                write_log(date("H:i:s ")." [$dateien_gesichert] $name ($file_groesse_kb KB)<br>\n");  //zu log hinzufuegen
             }
             else {   //Datei konnte nicht hinmzugefuegt werden
                write_log("</font>$format_negativ".date("H:i:s ")." <b>Fehler! Die Datei ". $name. " ($file_groesse_kb KB) konnte nicht gesichert werden.</b>
                </font><font color=\"#000000\" size=\"-5\"><br>\n");
             } 
         }
         else{  //Dateien ausschliessen
             $groesse_ausgeschlossen +=$file_groesse;
             $dateien_ausgeschlossen++;
             write_log(date("H:i:s ")."</font>$format_negativ
             Ausgeschlossen: $name ($file_groesse_kb KB)
             </font><font color=#000000 size=\"-5\"><br>\n");
         }
}


write_log("<br>\nDie Dateien wurden fertig eingelesen.<br>\n");

$success=$tar->addFile("status.htm","Bericht ueber die Sicherung vom ".$datum.".htm");    //Status-Datei dem Tar hinzufuegen   
 
 
 
 
$endzeit_einlesen=getmicrotime();
$zeit=substr ( $endzeit_einlesen-$startzeit, 0 , 5);
write_log("Bis jetzt wurden $zeit Sekunden ben&ouml;tigt<br>\n");

 
 
 
 
 
 
 
 
 
write_log("<br>\nDie Backup-Datei wird nun erstellt "); 
if($komprimierung=="false")
  write_log("(Komprimierung: Deaktiviert) ");    
else
  write_log("(Komprimierung: Aktiviert) ");  
write_log("(Dies kann einige Zeit dauern)...<br>\n"); 
      
// Save changes to a NEW tar file
if($komprimierung=="false")
  $file=($tar->toStream(false));    
else
  $file=($tar->toStream(true));  


$groesse_gesichert=$groesse_gesichert/1024/1024;  //in MB wandeln
$groesse_gesichert=substr( $groesse_gesichert, 0 , 5);  //Nachkomastellen kuerzen
$groesse_ausgeschlossen=$groesse_ausgeschlossen/1024/1024;  //in MB wandeln
$groesse_ausgeschlossen=substr( $groesse_ausgeschlossen, 0 , 5);  //Nachkomastellen kuerzen
write_log( "</font></p><h2><font color=green><b>.....::::: FERTIG :::::.....</b></font></h2>
<p>Es wurden total $groesse_gesichert MB in $dateien_gesichert Dateien  (von $dateien_total) gesichert.<br>
$groesse_ausgeschlossen MB in $dateien_ausgeschlossen Dateien  wurden vom Backup ausgeschlossen.<br>\n");

if (count($array_files_unlesbar)!=0){
  write_log("<br>\n</font>".$format_negativ.
            "Folgende Dateien oder der Ordner (inkl. den darin liegenden Dateien und Ordner) konnten nicht gelesen werden (Permission denied)
           und wurden deshalb vom Backup ausgeschlossen:<br>\n");
  foreach ($array_files_unlesbar as $value) { 
    $name=str_replace($basedir, "", $value);
    write_log("-$name<br>\n");  
  }
  write_log("</font><br>\n".$format_positiv);
}




$archiv_groesse= strlen($file);
$archiv_groesse=$archiv_groesse/1024/1024;  //in MB wandeln
$archiv_groesse=substr( $archiv_groesse, 0 , 5);//Nachkomastellen kuerzen
write_log("<br>\nDie Backup-Datei zum herunterladen ist <b>$archiv_groesse MB</b> gross!<br>\n<br>\n");

$endzeit=getmicrotime();
$zeit=substr ( $endzeit-$startzeit, 0 , 5);
write_log("Es wurden total $zeit Sekunden ben&ouml;tigt<br>\n");

write_log("<br>.\n<br>.\n<br>.\n<br>\n.....::::: EOF :::::...... <a href=\"index.php\" target=\"_parent\">zur&uuml;ck zur  Info-Seite (LOG wird gel&ouml;scht)</a>
</p>");

fclose ($fs);



/// Output ///////////////////////////////////////////////////////////////////////////////

// Datei zum Download anbieten
header("Content-type: application/octet-stream");
header("Content-disposition: attachment; filename=$filename");
echo  $file;
//echo "<br><br>debug: ENDE des Scriptes";

/* Nach dieser Zeile darf NICHTS mehr stehen!!!!!!!!!!!!!  */          ?>
