<?php

       /*-------------------------------------------------------------------*\
      //       (>"<)                                                          |
     //        o", ) Das Copyright dieses Scriptes liegt bei Fabian Schneider |
    //         (.(,) www.fabian-schneider.com  webmaster@fabian-schneider.com |
   //          '.'.J                  ICQ:147326489                           |
  //-------------------------------------------------------------------------/
 /*      Skript(Freeware): FS- Thumbnailer v. 1.1                          *|
<|*      Beschreibung: Diese Klasse dient dazu von vorgegebenen Bildern in *|
 \*            der Gre modifizierte Bilder zu erstellen (z.B. Thumbnails)*|
  \\-------------------------------------------------------------------------\
   \\            /)/)  Datei erstellt am: 25.09.2003                          |
    \\         =(';')= letzte nderung: 09.05.2004                            |
     \\        c(")(") Dateiname: class.thumbnailer.php                       |
      \\!!Das Copyright im Script und auerhalb darf nicht verndert werden!! |
       \*--------------------------------------------------------------------*/
        
?>

<?php

class Thumbnailer {

	//$this->{$bild} = &$strFileName;
    ######### Eigenschaften der Klasse/des Objekts
    var $autocreate = true; // soll das verkleinern der Bilder direkt beginnen? wenn ja, mssen die Eigenschaften korrekte Werte erhalten!!
    var $single_mode = false; // sollen nur einige Bilder oder alle Bilder im Ordner verkleinert werden?
    var $image_list = array(); // falls $single_mode = true, dann mssen hier die Bilder reingeschrieben werden, die verkleinert werden sollen
    var $ersetzen = false; // soll, wenn ein Bild bereits vorhanden ist, dieses ersetzt werden?
    var $image_ext = array("gif","jpg","jpeg","png","wbmp"); // untersttze Bildformate. nicht erweitern!
    var $image_dir = ""; // die Original Bilder
    var $thumb_dir = "./klein/"; // Ordner in dem die modifizierten Bilder gespeichert werden
    var $thumb_w = 110;//110; // Breite (width) der modifizierten Bilder
    var $thumb_h = 110;//110; // Hhe (height) der modifizierten Bilder
    
    ######### Methoden der Klasse/des Objekts
    ##### gibt alle Bilder mit den korrekten Endungen in einem Array zurck
    function list_all_images() {
        $files = array();
        $dir_handle = opendir($this->image_dir);
        while ($file = readdir($dir_handle)) {
            if ($file != "." && $file != ".." && !is_dir($this->image_dir.$file)) {
                $tmp_file = explode(".",$file);
                $i = 0;
                while ($i < count($this->image_ext)) {
                    if ($this->image_ext[$i] == strtolower($tmp_file[count($tmp_file)-1])) {
                        $files[] = $file;
                    }
                $i++;
                }
            }
        }
        closedir($dir_handle);
        return $files;
    }
    
    ##### Erstellt ein Thumbnail
    function create_thumb($filename) {
        $file = $this->image_dir.$filename;
        if ($this->ersetzen || !file_exists($this->thumb_dir.$filename)) {
            #### Bild- Datei und -Endung
            $tmp_file = explode(".",$file);
            $ext = strtolower($tmp_file[count($tmp_file)-1]);
            #### Bild aus Datei erstellen; Bildtypen mssen unterschieden werden
            if ($ext == "jpg" || $ext == "jpeg") {
                $img = imagecreatefromjpeg($file);
            } elseif ($ext == "gif") {
                $img = imagecreatefromgif($file);
            } elseif ($ext == "png") {
                $img = imagecreatefrompng($file);
            } elseif ($ext == "wbmp") {
                $img = imagecreatefromwbmp($file);
            } else {
                return false;
            }
            #### Gren ablesen
            $old_w = imagesx($img);
            $old_h = imagesy($img);
            #### neue Gren bestimmen
            if ($old_w > $old_h) {
                $thumb_w = $this->thumb_w;
                $thumb_h = $old_h*($this->thumb_w/$old_w);
            }
            if ($old_w < $old_h) {
                $thumb_w = $old_w*($this->thumb_h/$old_h);
                $thumb_h = $this->thumb_h;
            }
            if ($old_w == $old_h) {
                $thumb_w = $this->thumb_w;
                $thumb_h = $this->thumb_h;
            }
            #### Bild erzeugen in korrekter Gre
            $new_img = @imagecreatetruecolor($thumb_w,$thumb_h);
            if (!$new_img) {
                $new_img = imagecreate($thumb_w,$thumb_h);
                imagecopyresized($new_img,$img,0,0,0,0,$thumb_w,$thumb_h,$old_w,$old_h);
            } else {
                imagecopyresampled($new_img,$img,0,0,0,0,$thumb_w,$thumb_h,$old_w,$old_h);
            }
            #### Bild speichern; Bildtypen mssen unterschieden werden
            if ($ext == "jpg" || $ext == "jpeg") {
                imagejpeg($new_img,$this->thumb_dir.$filename);
            } elseif ($ext == "gif") {
                imagegif($new_img,$this->thumb_dir.$filename);
            } elseif ($ext == "png") {
                imagepng($new_img,$this->thumb_dir.$filename);
            } elseif ($ext == "wbmp") {
                imagewbmp($new_img,$this->thumb_dir.$filename);
            } else {
                return false;
            }
            #### Cache leeren
            imagedestroy($new_img);
            imagedestroy($img);
            return true;
        } else {
            return false;
        }
    }
    
    ##### Lsst Thumbnails anhand der Bilder im Ordner erzeugen
    function create_thumbs() {
    	if ($this->single_mode) {
    		$files = $this->image_list;
    	} else {
        	$files = $this->list_all_images();
        }
        $i = 0;
        while ($i < count($files)) {
            $this->create_thumb($files[$i]);
            $i++;
        }
        return true;
    }

    ##### Konstruktor fr die Klasse (wird nur ausgefhrt, wenn die Klasse sofort starten soll)
    function Thumbnailer() {
        if ($this->autocreate) {
            $this->create_thumbs();
        }
    }
    ######### Ende der Klasse/des Objekts
}

?>
