<?

class user
{
	var $db = NULL;
	
	var $_createtable="CREATE TABLE IF NOT EXISTS wn_user
	(user_id int(11) NOT NULL auto_increment,
	user_level int(3) not null default 1,
	user_last_name varchar(30) NOT NULL default 'Name',
	user_first_name varchar(50) NOT NULL default 'Vorname',
	user_name varchar(12) NOT NULL default '',
	user_password varchar(32) NOT NULL default '',
	user_mail varchar(150) NOT NULL default '',
	user_session varchar(32) default NULL,
	user_login datetime default NULL,
	user_last_action datetime NOT NULL default 0,
	user_logout datetime NOT NULL default 0,
	user_active varchar(32) NOT NULL default '',
	user_register datetime NULL,
	user_failed_login int(11) NOT NULL default 0,
	PRIMARY KEY  (user_id),
	UNIQUE KEY user_session (user_session),
	UNIQUE KEY user_name (user_name),
	UNIQUE KEY user_mail (user_mail))	
	TYPE=MyISAM";
	
	var $_addAdmin="INSERT INTO wn_user
	(user_level,user_name,user_password,user_mail,user_active,user_register)
	VALUES
	(1000,'admin',MD5('admin'),'mail@localhost.de','1',Now())";
	
	var $_db=array
		('host' => 'localhost',
		'user' => '',
		'pass' => '',		
		'name' => '',
		'table' => 'wn_user',
		'link' => NULL);
		
	var $_password=array
		('letters' => 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',
		'numbers' => '0123456789',
		'specials' => '!$%&/()=[]}+*~#-_');
	
	var $init_ok=false;
	
	var $timeout=600;
	var $logoutafter=-1;
	var $discardafter=2;
	var $usecookie=false;
	var $MaxFailedLogins=3;
	var $_new_pw=NULL;
			
	var $_sql=array();
	
	var $activation_link=NULL;
	
	var $_errors=array();
	
	//***************
	//
	//Public - Methoden
	//
	//***************
			
	function USER(&$db,$sessionname='mz',$timeout=600,$logoutafter=-1,$discardafter=2,$usecookie=false)
	//Konstruktor
	{
		//Dbase referenz
		$this->db = &$db;


	
		//Name der Session festlegen und Session starten
		@session_name($sessionname);
		@session_start();
		//Zufallsgenerator initialisieren
		mt_srand((double)microtime()*1000000);
		//Tabelle erstellen, falls noch nicht vorhanden
		##$this->db->query($this->_createtable); 
		//Standarduser hinzufgen
		##$this->db->query($this->_addAdmin); 
		//Initialisierung erfolgreich?
		$this->init_ok=!(isset($this->_errors) and count($this->_errors)>0);
		$this->activation_link=$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?activate=';
		if (!preg_match('%^http%siU',$this->activation_link))
			$this->activation_link='http://'.$this->activation_link;
		$this->set_timeout($timeout);
		$this->set_logoutafter($logoutafter);
		$this->set_discardafter($discardafter);				
		if (isset($_COOKIE[$sessionname.'login'])and !$this->logged_in())
			$this->_cookie_login($_COOKIE[$sessionname.'login']);
		$this->set_usecookie($usecookie);
	}
	
	function login($user,$pass,$ignore_already_logged_in=false)
	//Login
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Login',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		$sql="SELECT user_id, user_active, (Now()-user_last_action) as UserIdle, user_failed_login FROM ".$this->_db['table']." 
		WHERE user_name='$user' AND user_password=MD5('$pass')";
		##$result=$this->_runQuery($sql,false);
		$result = $this->db->query($sql); 
		if ( $this->db->numrows()!=1) //Kein passender Datensatz gefunden
		{
			$this->_add_error('Login',-1,'Kombination aus '.$user.' und '.$pass.' ist nicht korrekt.');
			if ($this->_password_false($user))
				$this->_incFailedLogins($user);
			return false;
		}
		//$userinfo=$result->fetchArrayRow();
		$userinfo=$this->db->numrows();
		if ($userinfo['user_failed_login']>=$this->MaxFailedLogins)
		{
			$this->_add_error('Login',-3,'Zu viel fehlerhafte Logins');
			return false;
		}
		if ($userinfo['user_active']!=1)
		{
			$this->_add_error('Login',-12,'User '.$user.' ist bis jetzt noch nicht freigeschalten worden.');
			return false;
		}
		if ($ignore_already_logged_in)
			return $this->_login($userinfo['user_id']);
		else
			if (!empty($userinfo['user_login']) and ($userinfo['UserIdle']<$this->timeout or $this->timeout==-1))
			{
				//User ist bereits eingeloggt, kein weiteres Einloggen erlaubt
				$this->_add_error('Login',-2,'User '.$user.' ist bereits eingeloggt.');
				return false;
			}
			else //Alles OK, einloggen
				return $this->_login($userinfo['user_id']);
	}
	
	function logged_in()
	//Ist der User eingeloggt?
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Login-Check',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		//Steht die aktuelle Session-ID in der DB, ist der User eingeloggt
		$sql="SELECT user_id,(Now()-user_last_action) as UserIdle FROM ".$this->_db['table']." WHERE user_session='".session_id()."'";
		$result=$this->db->query($sql);
		
		if ($this->db->numrows()>0)
		{
			$user=$this->db->fetchArrayRow();
			if ($user['UserIdle']<$this->logoutafter or $this->logoutafter==-1)
			{
				$sql='UPDATE '.$this->_db['table']." SET user_last_action = NOW() WHERE user_session = '".session_id()."'";
				$this->_runQuery($sql);
				$this->logout_idle();
				return true;
			}
			else
			{
				$this->logout(session_id());
				$this->logout_idle();
				return false;
			}
		}
		$this->logout_idle();
		return false;
	}
	
	function logout($sessionid=NULL)
	//User ausloggen
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Logout',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		if (!isset($sessionid))
			$sessionid=session_id();
		$sql='UPDATE '.$this->_db['table']." SET user_session = NULL, user_last_action=0,user_logout=NOW() WHERE user_session = '".$sessionid."'";
		$result=$this->_runQuery($sql);
		if ($sessionid==session_id())
			if ($result)
			{
				$this->set_usecookie(false);
				setcookie(session_name().'login',session_id(),time()-31536000,'/','',0);
				$_SESSION=array();
				session_destroy();
				return true;
			}
			else
			{
				$user=$this->return_user();
				$this->_add_error('Logout',-11,"User '".$user['user_name']."' konnte nicht ausgeloggt werden.");
				return false;
			}
		else
			return false;
	}
	
	function activate_user($activation_id)
	//User freischalten
	{
		$sql='UPDATE '.$this->_db['table']." SET user_active='1', user_failed_login=0 WHERE user_active='$activation_id'";
		$result=$this->_runQuery($sql);
		if (!$result)
		{
			$sql='SELECT user_name FROM '.$this->_db['table']." WHERE user_active='$activation_id'";
			$user=$this->_runQuery($sql,false);
			if ($user)
				$this->_add_error('Activate',-200,"User '".$user['user_name']."' konnte nicht freigeschalten werden.");
			return false;
		}
		return $this->_update_ok();
	}
	
	function has_Access($UserLevel)
	//Ist der Benutzer berechtigt, einen bestimmten Bereich zu betreten?
	{
		if (!$this->logged_in())
			return false;
		$user=$this->return_user();
		return ($user['UserLevel']>=$UserLevel);
	}

	function return_new_pw()

	{
		return $this->_new_pw;
		$this->_new_pw=NULL;
	}

	function set_usecookie($usecookie)
	//Soll die Session-ID in einem Cookie gespeichert werden
	{
		$this->usecookie=$usecookie;
		if ($usecookie)
		{
			$user=$this->return_user();
			$logindata=$user['user_id'].'|'.$user['user_password'];
			if (!isset($_COOKIE[session_name().'login']) or $_COOKIE[session_name().'login']!=$logindata)
				setcookie(session_name().'login',$logindata,time()+31536000,'/','',0);
		}
	}
	
	function return_usecookie()
	//Soll die Session-ID in einem Cookie gespeichert werden
	{
		return $this->usecookie;
	}

	function set_timeout($timeout)
	//Timeout, nachdem ein erneutes einloggen mglich sein soll
	{
		$this->timeout=$timeout;
	}
	
	function return_timeout()
	//Timeout, nachdem ein erneutes einloggen mglich sein soll
	{
		return $this->timeout;
	}
		
	function set_logoutafter($logoutafter)
	//Timeout fr automatischen Logout setzen
	{
		$this->logoutafter=$logoutafter;
	}
	
	function return_logoutafter()
	//Timeout fr automatischen Logout zurckliefern
	{
		return $this->logoutafter;
	}
	
	function set_discardafter($discardafter)
	//Zeitraum zwischen Anmeldung und Freischaltung
	{
		$this->discardafter=$discardafter;
	}
	
	function return_discardafter()
	//Zeitraum zwischen Anmeldung und Freischaltung
	{
		return $this->discardafter;
	}	
	
	function return_users()
	//ID, Username, UserLogin, LastAction und Idletime (in sec.) der momentan eingelogten User ermitteln
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Users-Info',-1001,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		//Inaktive fliegen raus
		$this->logout_idle();
		$sql="SELECT user_id, user_name, user_register,user_login,user_session, user_last_action, (Now()-user_last_action) as UserIdle 
		FROM ".$this->_db['table']." WHERE user_session IS NOT NULL";
		##$result=$this->_runQuery($sql,false);
		$result = new Query($sql); 

		$users=array();
		while ($user=$result->fetchArrayRow())
			$users[]=$user;
		return (count($users)>0) ? $users : false;
	}
		
	function return_user($sid=NULL)
	//User-Info zurckliefern
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('User-Info',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		if ($sid==NULL)
			$sid=session_id();
		$sql="SELECT user_id, user_level, user_last_name, user_first_name, user_name, user_password, user_mail, user_session, 
		user_login, user_last_action, (Now()-user_last_action) as UserIdle,user_register
		FROM ".$this->_db['table']." WHERE user_session='".$sid."'";
		//$result=$this->_runQuery($sql,false);	
		$result=$this->query($sql,false);	
		$user=$result->fetchArrayRow();
		return $user;
	}
	
	function add_user($Name, $Vorname, $UserName, $UserPasswd, $UserMail, $UserLevel=1)
	//User hinzufgen
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Neuer User',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		$activation_id=$this->_create_password(32,true,false);
		$sql='INSERT INTO '.$this->_db['table']." 
		(user_level, user_last_name, user_first_name, user_name, user_password, user_mail,user_register,user_active,user_last_action) 
		VALUES($user_level,'$Name','$Vorname','$UserName',MD5('$UserPasswd'),'$UserMail',Now(),'$activation_id',Now())";
		if ($this->_runQuery($sql))
		{
			$newuser=array('user_name' => $UserName,'ActivationLink' => $this->activation_link.$activation_id);
			return $newuser;			
		}
		else
			return false;
	}

	function new_password($mail,$length=8,$use_numbers=true,$use_specials=false,$force_reactivate=false)
	//Neues Passwort generieren und in DB eintragen
	//Mail an registrierte Adresse wird nicht automatisch verschickt
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Neues Passwort',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		$this->_new_pw=NULL;
		$pass=$this->_create_password($length,$use_numbers,$use_specials);
		if ($force_reactivate)
		//User soll sich neu freischalten mit neuem Passwort
			$useractivate=md5('$pass');
		else
			$useractivate='1';
		$sql='UPDATE '.$this->_db['table']." SET user_active='$useractivate', user_password = MD5('$pass') WHERE user_mail='$mail'";
		$result=$this->_runQuery($sql);
		if ($result and $this->_update_ok())
		{
			$this->_new_pw=array('pass' => $pass,'mail' => $mail, 'activate' => $this->activation_link.$useractivate);
			return true;
		}
		$this->_add_error('Neues Passwort',-21,"Das Passwort konnte nicht geaendert werden.");
		return false;		
	}

	function change_password($old,$new,$force_reactivate=false)
	//Neues Passwort in DB eintragen
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Passwort ndern',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		if ($force_reactivate)
		//User soll sich neu freischalten mit neuem Passwort
			$useractivate=md5('$new');
		else
			$useractivate='1';
		$user=$this->return_user();
		$sql='UPDATE '.$this->_db['table']." SET user_active='$useractivate', user_password = MD5('$new') WHERE user_password = MD5('$old') AND user_id=".$user['user_id'];
		$result=$this->_runQuery($sql);
		if ($result and $this->_update_ok())
		{
			if ($force_reactivate)
			{
				$user=$this->return_user();
				$newuser=array('user_name' => $user['user_name'],'ActivationLink' => $this->activation_link.$useractivate);
				return $newuser;
			}
			else
				return true;
		}
		$this->_add_error('Passwort aendern',-21,"Das Passwort konnte nicht geaendert werden.");
		return false;		
	}
	
	function has_errors()
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
			$this->_add_error('Login',-1000,'Klasse nicht erfolgreich initialisiert.');
		return (isset($this->_errors)) ? count($this->_errors)>0 : false;
	}
	
	function return_errors()
	{
		if ($this->has_errors())
			return $this->_errors;
	}
	
	function reset_errors()
	{
		unset($this->_errors);
	}
	
	function return_sql()
	{
		if (isset($this->_sql))
			return $this->_sql;
	}
	
	function free($logout=false)
	//Destruktor
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Login',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		if ($this->logged_in() and $logout)
			$this->logout();
		elseif ($this->logged_in())
			session_destroy();
		##if(isset($this->_db['link']))
			##@mysql_close($this->_db['link']) or $this->_add_error('DB-Verbindung beenden',mysql_errno(),mysql_error());
		##unset($this->_db['link']);
		return true;
	}
	
	//***************
	//
	//Private Methoden - _Nicht_ von extern aus aufrufen
	//
	//***************
	
	function _login($userid)
	{
		$sql='UPDATE '.$this->_db['table']." SET user_session = '".session_id()."',user_login = NOW(), 
		user_last_action=Now() ,user_logout=0, user_failed_login=0 WHERE user_id = $userid";
		if ($this->_runQuery($sql))
		{
			if ($this->usecookie)
				$this->set_usecookie(true);
			return true;
		}
		else
		{
			$this->_add_error('Login',-3,"User '".$this->_db['user_name']."' (ID: $userid) konnte nicht eingeloogt werden.");
			return false;
		}
	}
	
	/*function _runQuery($sql,$add_error=true)
	{
		$result=@mysql_query($sql,$this->_db['link']);
		if (!$result and $add_error)
			$this->_add_error('SQL: '.$sql,mysql_errno(),mysql_error());
		$this->_add_sql($sql);
		return $result;
	}*/
	
	function _add_sql($sql)
	{
		$eintrag=array('Zeitpunkt' => date('Y-m-d H:i:s'), 'SQL' => $sql);
		$this->_sql[]=$eintrag;
	}
	
	function _add_error($err_at,$err_no=NULL,$err_desc=NULL)
	{
		$eintrag=array('where' => $err_at,'Zeitpunkt' => date('Y-m-d H:i:s'),'#'=>$err_no,'desc'=>$err_desc);
		$this->_errors[]=$eintrag;
	}
	
	function _create_password($length,$use_numbers,$use_specials)
	{
		$pass=$this->_password['letters'];
		if ($use_numbers)
			$pass.=$this->_password['numbers'];
		if ($use_specials)
			$pass.=$this->_password['specials'];
		$realpass=NULL;
		for($i=0;$i<$length;$i++)
			$realpass.=$pass[mt_rand(0,strlen($pass)-1)];
		return $realpass;
	}
	
	function _cookie_login($relogin)
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Login',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		$logindata=explode('|',$relogin);
		$sql="SELECT user_id, user_active FROM ".$this->_db['table']." WHERE user_id=".$logindata[0]." AND user_password='".$logindata[1]."'";
		##$result=$this->_runQuery($sql,false);
		$result = $this->db->query($sql); 

		if (!$this->db->getNumRows()>0) //Kein passender Datensatz gefunden
		{
			$this->_add_error('Login',-1,'Login anhand der Cookie-Daten ist nicht mglich.');
			return false;
		}
		$userinfo=$result->fetchArrayRow();
		if ($userinfo['user_active']!=1)
		{
			$this->_add_error('Login',-12,'User '.$user.' ist bis jetzt noch nicht freigeschalten worden.');
			return false;
		}
		return $this->_login($userinfo['user_id']);
	}
	
	function _password_false($user)
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Login',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		$sql='SELECT user_id FROM '.$this->_db['table']." WHERE user_name='$user'";
		$result = $this->db->query($sql);
		return ($this->db->numrows()>0);
	}

	function _incFailedLogins($user)
	{
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Login',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}
		$sql='UPDATE '.$this->_db['table']." SET user_failed_login=user_failed_login+1 WHERE user_name='$user'";
		##$this->_runQuery($sql,false);
		$result = new Query($sql); 

		$sql='SELECT user_mail, user_failed_login FROM '.$this->_db['table']." WHERE user_name='$user'"; 
		$result = $this->db->query($sql);
		if ($this->db->numrows()>0)
		{
			$failedLogins=$result->fetchArrayRow();

			if ($failedLogins['user_failed_login']==$this->MaxFailedLogins)
				$this->new_password($failedLogins['user_mail'],8,true,false,true);
		}
	}
	
	function logout_idle()
	{		
		if (!$this->init_ok) //Keine Initialisierung => Abbrechen
		{
			$this->_add_error('Login',-1000,'Klasse nicht erfolgreich initialisiert.');
			return false;
		}		
		if ($this->logoutafter!=-1)
		{
			$sql='UPDATE '.$this->_db['table'].'
			SET user_session = NULL, user_last_action=0,user_logout=NOW() 
			WHERE (Now()-user_last_action)>'.$this->logoutafter;
			$this->_runQuery($sql,false);
		}
		//User, die sich vor mehr als zwei Tagen registriert haben, aber noch nicht freigeschaltet sind, fliegen raus
		$sql='DELETE FROM '.$this->_db['table']." WHERE user_active!='1' AND (user_register + INTERVAL ".$this->discardafter." DAY)<Now() AND (user_last_action + INTERVAL ".$this->discardafter." DAY)<Now()";
		$this->db->query($sql);
	}
	
	function _update_ok()
	{
		return (mysql_affected_rows($this->_getLink())>0);
	}
		
}
?>