<?php
/*
 * Erstellt von Daniel Messer (2005)
 */

set_include_path(realpath(dirname(__FILE__)."/../../").":".get_include_path());

require_once "PHPUnit2/Framework/TestCase.php";
require_once "development/lib/template/XSLTemplate.php";

class XSLTemplate_Test extends PHPUnit2_Framework_TestCase
{
	public function testTemplatePathIsRelatedToProjectRoot()
	{
		$cfg = Configuration::loadResource();
		$cfg->set("path", "../testing/template", "template");
		$cfg->write();
		
		try
		{
			$tpl = new XSLTemplate("test");
		}
		catch(XSLTemplate_Exception $e)
		{
			$thrownException = $e;
		}
		
		$cfg->set("path", "tpl/", "template");
		$cfg->write();

		if(isset($thrownException))
		{
			$this->assertTrue(false, "Exception thrown: ".$thrownException->getMessage());
		}
		else
		{
			$this->assertTrue(true);
		}
	}
	
	public function testImportedTemplateContentIsMergedWithMasterTemplate()
	{
		$cfg = Configuration::loadResource();
		$cfg->set("path", "../testing/template", "template");
		$cfg->write();
		
		$tpl = new XSLTemplate("test");
		
		$cfg->set("path", "tpl/", "template");
		$cfg->write();
		
		$tpl->importTemplate("import");
		
		$domMaster = DOMDocument::load(realpath(dirname(__FILE__)."/test.xsl"));		
		$domImport = DOMDocument::load(realpath(dirname(__FILE__)."/import.xsl"));
		
		$sourceNode = $domImport->getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "stylesheet")->item(0);
		$destinationNode = $domMaster->getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "stylesheet")->item(0);
		
		foreach($sourceNode->childNodes as $childNode)
		{
			if(($childNode->prefix == "xsl") && ($childNode->localName != "output"))
			{
				$importedNode = $domMaster->importNode($childNode, TRUE);
				$destinationNode->appendChild($importedNode);
			}	
		}
		
		$domMaster->formatOutput = true;
		
		$this->assertEquals($domMaster->saveXML(), $tpl->saveXSL());
	}
	
	public function testExceptionIsThrownIfRootNodeNotFoundWhenImportingStylesheets()
	{
		$cfg = Configuration::loadResource();
		$cfg->set("path", "../testing/template", "template");
		$cfg->write();
		
		$tpl = new XSLTemplate("test");
		
		$cfg->set("path", "tpl/", "template");
		$cfg->write();
		
		try
		{
			$tpl->importTemplate("import_broken");
		}
		catch(XSLTemplate_Exception $e)
		{
			$thrownException = $e;
		}
		
		$this->assertTrue(isset($thrownException), "No exception is thrown when xsl:stylesheet-node is missing in imported template");
	}
	
	public function testArraysAssignedToTheTemplateAreThreadedInNodeStructures()
	{
		$cfg = Configuration::loadResource();
		$cfg->set("path", "../testing/template", "template");
		$cfg->write();
		
		$tpl = new XSLTemplate("test");
		
		$cfg->set("path", "tpl/", "template");
		$cfg->write();
		
		$tpl->test = array(array("test1-1", "value1-1"), array("test1-2","value1-2"));
		$tpl->test2 = "value2";
		$tpl->test3 = "value3";
		
		$xmlData = new DOMDocument("1.0", "UTF-8");
		$xmlData->formatOutput = true;
		$rootNode = $xmlData->appendChild($xmlData->createElement("master"));
		
		$test1 = $rootNode->appendChild($xmlData->createElement("test"));
		$test1->appendChild($xmlData->createElement("test1-1", "value1-1"));
		$test1->appendChild($xmlData->createElement("test1-2", "value1-2"));
		
		$rootNode->appendChild($xmlData->createElement("test2", "value2"));
		$rootNode->appendChild($xmlData->createElement("test3", "value3"));
		
		$this->assertEquals($xmlData->saveXML(), $tpl->saveXMLData());
	}
	
	public function testMultipleVariableAssignmentsAreMappedToMultipleVariablesWithTheSameName()
	{
		$cfg = Configuration::loadResource();
		$cfg->set("path", "../testing/template", "template");
		$cfg->write();
		
		$tpl = new XSLTemplate("test");
		
		$cfg->set("path", "tpl/", "template");
		$cfg->write();
		
		$tpl->test1 = "test1";
		$tpl->test2 = "value2";
		$tpl->test2 = "value3";
		
		$xmlData = new DOMDocument("1.0", "UTF-8");
		$xmlData->formatOutput = true;
		$rootNode = $xmlData->appendChild($xmlData->createElement("master"));
		
		$rootNode->appendChild($xmlData->createElement("test1", "test1"));
		$rootNode->appendChild($xmlData->createElement("test2", "value2"));
		$rootNode->appendChild($xmlData->createElement("test2", "value3"));
		
		$this->assertEquals($xmlData->saveXML(), $tpl->saveXMLData());
	}
	
	public function testAssociativeArraysAreMappedToPairArraysInTemplateVariables()
	{
		$cfg = Configuration::loadResource();
		$cfg->set("path", "../testing/template", "template");
		$cfg->write();
		
		$tpl = new XSLTemplate("test");
		
		$cfg->set("path", "tpl/", "template");
		$cfg->write();
		
		$tpl->test1 = array(array("test1-1", "value1-1"), "test1-2" => "value1-2");
		$tpl->test2 = array("test1-1" => "value1-1", "test1-2" => "value1-2"); // same as above...
		
		$xmlData = new DOMDocument("1.0", "UTF-8");
		$xmlData->formatOutput = true;
		$rootNode = $xmlData->appendChild($xmlData->createElement("master"));
		
		$test1 = $rootNode->appendChild($xmlData->createElement("test1"));
		$test1->appendChild($xmlData->createElement("test1-1", "value1-1"));
		$test1->appendChild($xmlData->createElement("test1-2", "value1-2"));
		
		$test2 = $rootNode->appendChild($xmlData->createElement("test2"));
		$test2->appendChild($xmlData->createElement("test1-1", "value1-1"));
		$test2->appendChild($xmlData->createElement("test1-2", "value1-2"));
		
		$this->assertEquals($xmlData->saveXML(), $tpl->saveXMLData());
	}
}

?>
