<?

class cXMLFile
{
	var $parser;
	var $roottag;
	var $curtag;
	
	function XMLFile()
	{
		$this->init();
	}
	
	function cleanup()
	{
		if ( is_object($this->roottag) )
			$this->roottag->clear_subtags();
	}
	
	function init()
	{
		$this->roottag = '';
		$this->curtag = &$this->roottag;
	}
	
	function create_root($strValue = NULL)
	{
		$this->roottag = '';
		$this->curtag = &$this->roottag;
	}
	
	function read_file_handle($fh)
	{
		$this->init();
		$this->parser = xml_parser_create("UTF-8");
		xml_set_object($this->parser, &$this);
		xml_set_element_handler($this->parser, "_tag_open", "_tag_close");
		xml_set_character_data_handler($this->parser, "_cdata");
		
		while ( $data = fread($fh, 4096) )
		{
			if ( !xml_parse($this->parser, $data, feof($fh)) )
				die (sprintf("XML-Error: %s at line %d", xml_error_string(xml_get_error_code($this->parser)),
							xml_get_current_line_number($this->parser)));
		}
				
		xml_parser_free($this->parser);
	}
	
	function write_file_handle($fh, $write_header = 1)
	{
		if ( $write_header )
			fwrite($fh, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		
		$this->roottag->write_file_handle($fh);
	}
	
	function _tag_open($parser, $tag, $attributes)
	{
		if ( !is_object($this->curtag) )
		{
			$this->curtag = new cXMLTag();
			$this->curtag->set_name($tag);
			$this->curtag->set_attributes($attributes);
		}
		else
		{
			$this->curtag->add_subtag($tag, $attributes);
			$this->curtag = &$this->curtag->curtag;
		}
	}
	
	function _tag_close($parser, $tag)
	{
		$this->curtag = &$this->curtag->parent;
	}
	
	function _cdata($parser, $data)
	{
		$this->curtag->add_cdata($data);
	}
}

?>