<?

#if ( !isset($XMLFile_Included) || !$XMLFile_Included )

class cXMLTag
{
	var $cdata;
	var $attributes;
	var $name;
	var $tags;
	var $parent;
	
	var $curtag;
	
	function cXMLTag($parent = 0)
	{
		if ( is_object($parent) )
			$this->parent = &$parent;
		
		$this->_init();
	}
	
	function _init()
	{
		$this->attribtues = array();
		$this->cdata = '';
		$this->name = '';
		$this->tags = array();
	}
	
	function add_subtag($name, $attributes = 0)
	{
		$tag = new cXMLTag(&$this);
		$tag->set_name($name);
		if ( is_array($attributes) )
			$tag->set_attributes($attributes);
		
		$this->tags[] = &$tag;
		$this->curtag = &$tag;
	}
	
	function clear_subtags()
	{
		$numtags = sizeof($this->tags);
		$keys = array_keys($this->tags);
		foreach ( $keys as $k )
		{
			$htis->tags[$k]->clear_subtags();
			unset($this->tags[$k]->parent);
		}
		
		$this->tags = array();
		unset($this->curtag);
	}
	
	function remove_subtag($index)
	{
		if ( is_object($this->tags[$index]) )
		{
			unset($this->tags[$index]->parent);
			unset($this->tags[$index]);
		}
	}
	
	function num_subtags()
	{
		return sizeof($this->tags);
	}
	
	function add_attribute($name, $val)
	{
		$this->attributes[strtoupper($name)] = $val;
	}
	
	function clear_attributes()
	{
		$this->attributes = array();
	}
	
	function set_name($name)
	{
		$this->name = strtoupper($name);
	}
	
	function set_attributes($attributes)
	{
		$this->attributes = (is_array($attributes)) ? $attributes : array();
	}
	
	function add_cdata($data)
	{
		$data = trim($data);
		$data = rtrim($data);
		if ( !empty($data) )
			$this->cdata .= $data;
	}
	
	function clear_cdata()
	{
		$this->cdata = '';
	}
	
	function write_file_handle($fh, $prepend_str = '')
	{
		$attrs = array();
		$attr_str = '';
		
		if ( count($this->attributes) > 0 )
			foreach ( $this->attributes as $key => $val )
				$attrs[] = strtoupper($key) . "=\"".$val."\"";

		if ( $attrs )
			$attr_str = join(" ", $attrs);
		
		$tagstr = "$prepend_str<{$this->name}";
		if ( $attr_str )
			$tagstr .= " $attr_str";
		
		$keys = array_keys($this->tags);
		$numtags = sizeof($keys);
		$trimmeddata = trim($this->cdata);
		
		if ( $numtags && ($trimmeddata == "") )
			$tagstr .= ">\n";
		elseif ( !$numtags && ($trimmeddata == "") )
			$tagstr .= "/>\n";
		else
			$tagstr .= ">";
		
		fwrite($fh, $tagstr);
		
		if ( $trimmeddata != "" )
			fwrite($fh, $trimmeddata);
		
		foreach ( $keys as $k )
			$this->tags[$k]->write_file_handle($fh, "$prepend_str\t");
		
		
		if ( $numtags || $trimmeddata != "" )
		{
			$tagstr = "</{$this->name}>\n";
			if ( $numtags )
				$tagstr = "$prepend_str$tagstr";
			
			fwrite($fh, $tagstr);
		}
	}	
}

?>