<?php

setlocale(LC_ALL, "ge");
if (!isset($_GET['start']))
{
	$_GET['start'] = time();
}

$monat = (int) strftime("%m", $_GET['start']);
$jahr = strftime("%Y", $_GET['start']);

if ($jahr % 400 == 0 || ($jahr % 100 != 0 && $jahr % 4 == 0))
{
	// Schaltjahr
	// 0 = Dez des Vorjahr, 13 = Jan des Folgejahrs
	$tagemonat = array(31, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31);
}
else
{
	// Kein Schaltjahr
	// 0 = Dez des Vorjahr, 13 = Jan des Folgejahrs
	$tagemonat = array(31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31);
}

$erster = mktime(12, 0, 0, $monat, 1, $jahr);
$letzter = mktime(12, 0, 0, $monat, $tagemonat[$monat], $jahr);

$vormonat = $erster - 86400;
$folgemonat = $letzter + 86400;

$wochentag = strftime("%w", $erster);
if ($wochentag == 0)
{
	$wochentag = 7;
}

$woche = 0;
for($wtag = 0; $wtag < $wochentag -1; $wtag++)
{
	$TPL['tag'][$woche][$wtag]['class'] = "KalenderAndererMonat";
	$TPL['tag'][$woche][$wtag]['text'] = ($tagemonat[$monat -1] +2 + $wtag - $wochentag) .".";
	$TPL['tag'][$woche][$wtag]['datum'] = $TPL['tag'][$woche][$wtag]['text'] . strftime("%m.%Y", $vormonat);
}

$dieserMonat = strftime("%m.%Y", $erster);
for ($tag = 1; $tag <= $tagemonat[$monat];)
{
	for ($wtag = $wochentag -1; $tag <= $tagemonat[$monat] && $wtag < 7; $wtag++)
	{
		$wochentag = 1;
		if ($wtag > 4)
		{
			$TPL['tag'][$woche][$wtag]['class'] = "KalenderWochenende";
		}
		else
		{
			$TPL['tag'][$woche][$wtag]['class'] = "Kalender";
		}
		$TPL['tag'][$woche][$wtag]['text'] = $tag .".";
		$TPL['tag'][$woche][$wtag]['datum'] = $tag .".". $dieserMonat;
		$tag++;
	}
	if ($wtag == 7)
	{
		$wtag = 0;
		$woche++;
	}
}

for (; $wtag > 0 && $wtag < 7; $wtag++)
{
	$TPL['tag'][$woche][$wtag]['class'] = "KalenderAndererMonat";
	$TPL['tag'][$woche][$wtag]['text'] = ($tag - $tagemonat[$monat]) .".";
	$TPL['tag'][$woche][$wtag]['datum'] = ($tag - $tagemonat[$monat]) .".". strftime("%m.%Y", $folgemonat);
	$tag++;
}

$TPL['vormonat'] = $vormonat;
$TPL['monat'] = $erster;
$TPL['folgemonat'] = $folgemonat;
$TPL['field'] = $_GET['field'];

require("ktemp/kalender.tpl.php");
?>
