<?php

//Uploadscript Configuration

$passwd     = "password";		//Password of the upload script

?>
<?php


/****************************************
 *    ZipLib
 * This file is part of the ZipLib.
 * 
 * This file implements the ZipArchive Class.
 * 
 *  @author  Florian Ha�ann<hassmann@flottix.com>
 *  @version 0.0.1 Development
 *  @file    /zip/class.ZipArchive.php
 *  @release 06.12.2006
 *  @website http://cms.flottix.com/
 *  @id      595D600BB34F7F6768ABB999924D4706
 *  @status  development
 ****************************************/
//______________________________________________________________________________
//Configuration Flags
define("ZIP_ARCHIVE_CRC_CHECK",1);		//Activate CRC Check Functionality
define("ZIP_ARCHIVE_SHOW_LOG",2);		//Activate Log Functionality
//______________________________________________________________________________
//Compression Method
define("ZIP_ARCHIVE_UNCOMPRESSED",0);	//no compression
define("ZIP_ARCHIVE_DEFLATE",8);		//DEFLATE compression
//______________________________________________________________________________
//Element Types
define("ZIP_ARCHIVE_FILE",1);			//The Record is a file
define("ZIP_ARCHIVE_STR_TMP",2);		//The Record is a String saved as TMP-File
define("ZIP_ARCHIVE_STR",3);			//The Record is a simple String
define("ZIP_ARCHIVE_STR_OFF",4);		//The Record is a String being an offset of a file
define("ZIP_ARCHIVE_DIR",5);			//The Record is a Directory
//______________________________________________________________________________
/****************************************
 * Comfortable unpack function
 ****************************************/
function unpack2($format,$str)
{
	$format2="";
	for($i=0; $i<strlen($format); $i++)
	{
		if($i)	$format2.="/";
		$format2.=$format[$i]."e".$i;
	}
	$res	=	unpack($format2,$str);
	$res2	=	array();
	foreach($res as $elem)
		array_push($res2,$elem);
	return $res2;
}
//______________________________________________________________________________
/****************************************
 *  class CZipArchive
 * 
 * This class represents a ZipArchive.
 * 
 * @author Florian Ha�ann
 * @updated 06.12.2006
 ****************************************/
class CZipArchive
{
	//__________________________________________________________________________
	//ZIP Archive properties
	var $m_sComment		=	"";			//The ZipArchive Comment
	var $m_iFlags		=	0;			//The configuration Flags
	var $m_sLog			=	"";			//The Log Data
	//__________________________________________________________________________
	//ZIP Archive internally values
	var $m_rFile		=	null;		//The input file ressource
	var $m_aoFiles		=	array();	//Array including all the file objects
	var $m_aoDir		=	array();	//Array including all the direcory objects
	var $m_asTMPFiles	=	array();	//Array including all tmp-files
	var $m_aoChilds		=	array();	//The top Level file and directory objects
	var $m_iSize		=	0;			//The size of the archive
	var $m_lCM			=	0;			//The standard compression method
	//__________________________________________________________________________
	/****************************************
	 *   free();
	 * This function clears the temporary files.
	 ****************************************/
	function free()
	{
		if($this->m_rFile)
			@fclose($this->m_rFile);
		foreach($this->m_asTMPFiles as $filename => $res)
		{
			if($res)
				@fclose($res);
			@unlink($filename);
		}
		return true;
	}
	//__________________________________________________________________________
	/****************************************
	 *   load($filename);
	 * This function loads an existing ZipArchive.
	 ****************************************/
	function load	($filename
					)
	{
		if(!file_exists($filename))
			return false;
		$this->m_rFile	=	$rFile	=	@fopen($filename,"rb");		//Read File binary
		$this->m_iSize	=	filesize($filename);
		
		while($junk	=	fread($rFile,4))	//Read 4 Byte Junk
		{
			if(strlen($junk)<4)		//junk should be 4bytes size
				break;
			$tmp	=	unpack2("V",$junk);		//convert to long int
			$junk	=	$tmp[0];
			switch($junk)
			{
				case	0x04034b50	:	//Local File Header
				{
					$tmp				=	unpack2("vvvVVVVvv",fread($rFile,26));	//read local file header
					$elem				=	&new CZipRecord($this);
					$elem->m_lGPBF		=	$tmp[1];								//general purpose bit flag
					$elem->m_lCM		=	$tmp[2];								//compression method
					$elem->m_lCRC		=	$tmp[4];								//crc check sum
					$elem->m_lCSize		=	$tmp[5];								//compressed size
					$elem->m_lSize		=	$tmp[6];								//real ( uncompressed ) size
					if($tmp[7])
						$elem->m_sPath	=	fread($rFile,$tmp[7]);					//reads the filename
					if($tmp[8])
						$elem->m_sExtrafields	=	fread($rFile,$tmp[8]);			//reads the extra fields
					$elem->m_iType		=	ZIP_ARCHIVE_STR_OFF;
					$elem->m_sFilename	=	basename($elem->m_sPath);
					$dir	=	dirname($elem->m_sPath)."/";
					if($dir=="./")
						$this->m_aoChilds[$elem->m_sFilename]	=	&$elem;
					elseif($this->m_aoDir[$dir])
						$this->m_aoDir[$dir]->m_aoChilds[$elem->m_sFilename]	=	&$elem;
					if($elem->m_sPath[strlen($elem->m_sPath)-1]=="/")	//This should be changed in further versions
					{
						$elem->m_iType		=	ZIP_ARCHIVE_DIR;
						$this->m_aoDir[$elem->m_sPath]	=	&$elem;
					}
					else
						$this->m_aoFiles[$elem->m_sPath]	=	&$elem;
					$elem->m_lOffset	=	ftell($rFile);
					fseek($rFile,ftell($rFile)+$elem->m_lCSize);
					if($gpbf&8)		//check if bit flag 3 is set
					{
						$tmp	=	unpack("V",fread($rFile,4));
						$elem->m_iCRC	=	$tmp[0];
						fseek($rFile,ftell($rFile)+8);		//jump data descriptor
					}
				}	break;
				case	0x02014b50		:	//Central Directory Record
				{
					/* here the central directory should be read in future */
					$tmp	=	unpack2("vvvvvvVVVvvvvvVV",fread($rFile,42));
					if($tmp[9])
						fread($rFile,$tmp[9]);
					if($tmp[10])
						fread($rFile,$tmp[10]);
					if($tmp[11])
						fread($rFile,$tmp[11]);
				}	break;
				case	0x06054b50		:	//End of Central Dir Record
				{
					$tmp	=	unpack2("vvvvVVv",fread($rFile,18));
					if($tmp[6])
						$this->m_sComment	=	fread($rFile,$tmp[6]);
				}	break;
			}
		}
		
		return true;
	}
	//__________________________________________________________________________
	/****************************************
	 *   addDir($path);
	 * This function adds a dir to the zipArchive
	 ****************************************/
	function addDir	($spath	//The path of the directory
					)
	{
		$apath	=	explode("/",$spath);
		$elem	=	&new CZipRecord($this);
		$elem->m_iType		=	ZIP_ARCHIVE_DIR;
		$elem->m_sPath		=	$spath;
		$elem->m_sFilename	=	basename($spath);
		unset($apath[sizeof($apath)-1]);
		unset($apath[sizeof($apath)-1]);
		if(implode("/",$apath))
			$this->m_aoDir[implode("/",$apath)."/"]->m_aoChilds[$elem->m_sFilename]	=	&$elem;
		else
			$this->m_aoChilds[$elem->m_sFilename]	=	&$elem;
		$this->m_aoDir[$elem->m_sPath]	=	&$elem;
		return true;
	}

	//__________________________________________________________________________
	/****************************************
	 *   addFile($archivefilename,$filename);
	 * This function adds a file to the archive by giving its contents as string.
	 ****************************************/
	function addFile		($spath				//ZipArchive Path
							,$filename			//Input File Path
							)
	{
		if(!file_exists($filename))
			return false;
		$apath	=	explode("/",$spath);
		
		$elem	=	&new CZipRecord($this);
		$elem->m_iType			=	ZIP_ARCHIVE_FILE;
		$elem->m_sPath			=	$spath;
		$elem->m_sFilename		=	basename($spath);
		$elem->m_lSize			=	filesize($filename);
		$elem->m_sInpFilename	=	$filename;
		$elem->m_lCM			=	$this->m_lCM;	//copy standard compression method
		unset($apath[sizeof($apath)-1]);
		if(implode("/",$apath))
			$this->m_aoDir[implode("/",$apath)."/"]->m_aoChilds[$elem->m_sFilename]	=	&$elem;
		else
			$this->m_aoChilds[$elem->m_sFilename]	=	&$elem;
		$this->m_aoFiles[$elem->m_sPath]	=	&$elem;
		return true;
	}
	//__________________________________________________________________________
	/****************************************
	 *   save($filename,$o);
	 * This functions saves an existing ZipArchive
	 * to a file.
	 *  @filename	Dateiname
	 *  @o			Overwrite
	 ****************************************/
	function save	($filename
					,$o	=	false
					)
	{
		if(file_exists($filename))
		{
			if($o)
				unlink($filename);
			else
				return false;
		}
		//______________________________________________________________________
		$rFile	=	@fopen($filename,"w+b");	//Open file binary
		//______________________________________________________________________
		$centralDir	=	"";
		$elem		=	array();
		foreach($this->m_aoDir as $path => $e)
			$elem[$path]	=	&$this->m_aoDir[$path];
		foreach($this->m_aoFiles as $path => $e)
			$elem[$path]	=	&$this->m_aoFiles[$path];
		foreach($elem as $path => $row)
		{
			//__________________________________________________________________
			$offset	=	ftell($rFile);
			$source	=	"";
			$this->m_sLog	.=	$row->m_sPath."\n";
			if($row->m_iType!=ZIP_ARCHIVE_DIR)	//If row is a file
			{
				$row->open();
				$source	=	$row->getContents();
				$csize	=	$size	=	pack("V",strlen($source));
				$crc	=	pack("V",crc32($source));
				$row->close();
			}
			else
			{
				$crc=pack("V",0);
				$csize	=	$size=pack("V",0);
			}
			
			$fnsize	=	pack("v",strlen($path));	//path size
			//__________________________________________________________________
			//put compression
			switch($row->m_lCM)
			{
				case	8	:	
				{
					$source	=	gzdeflate($source,1);
					$csize	=	pack("V",strlen($source));
				}	break;
				default		:	//unknown or no compression
				{
				}	break;
			}
			//__________________________________________________________________
			$gpbf	=	pack("v",0);
			if($row->m_lCM==8)
				$version	=	pack("v",20);
			else
				$version	=	pack("v",10);
			@fwrite($rFile,"\x50\x4b\x03\x04".$version.$gpbf.pack("v",$row->m_lCM).pack("V",0).$crc.$csize.$size.$fnsize."\x00\x00".$path);
			if($source)	//put content of the file
				@fwrite($rFile,$source);
			//__________________________________________________________________
			$centralDir.="\x50\x4b\x01\x02".$version.$version."\x00\x00".pack("v",$row->m_lCM)."\x00\x00\x00\x00".$crc.$csize.$size.$fnsize."\x00\x00\x00\x00\x00\x00";
			if($row->m_iType==ZIP_ARCHIVE_DIR)
				$centralDir.="\x00\x00".pack("V",16);
			else
				$centralDir.="\x00\x00".pack("V",32);
			$centralDir.=pack("V",$offset).$path;
		}
		$centralDirOffset	=	ftell($rFile);
		@fwrite($rFile,$centralDir);
		@fwrite($rFile,"\x50\x4b\x05\x06"."\x00\x00\x00\x00".pack("v",sizeof($elem)).pack("v",sizeof($elem)).pack("V",strlen($centralDir)).pack("V",$centralDirOffset)."\x00\x00");
		//______________________________________________________________________
		$this->m_iSize	=	ftell($rFile);
		@fclose($rFile);
		//______________________________________________________________________
		return true;
	}
};

//______________________________________________________________________________

class CZipRecord
{
	var $m_oZipArchive	=	null;		//The Zip Archive Object
	var $m_iType		=	0;			//The type of the ZipArchive Record
	var $m_lOffset		=	0;			//The offset of the file contents beginning
	var $m_sData		=	"";			//The contents of the file
	var $m_lGPBF		=	0;			//general purpose bit flag
	var $m_lCM			=	0;			//The compression method
	var $m_lCRC			=	0;			//The CRC-Check Sum
	var $m_lSize		=	0;			//The size of the record in Bytes
	var $m_lCSize		=	0;			//The compressed size of the record in Bytes
	var $m_sFilename	=	"";			//The Filename in the ZIP-Archive
	var $m_sPath		=	"";			//The full path in the ZIP-Archive
	var $m_sExtraFields	=	"";			//A string including the extra fields
	var $m_rFile		=	null;		//The File ressorce
	var $m_aoChilds		=	array();	//The child Records
	var $m_sInpFilename	=	"";			//The filename of the input file or of the temporary file
	
	function CZipRecord(&$parent) {
		$this->m_oZipArchive	=	&$parent;
	}
	
	function init() {
		if($this->m_iType==ZIP_ARCHIVE_STR_TMP)
		{
			if(!file_exists("./.ziptmp/"))
				mkdir("./.ziptmp/");
			$this->m_sInpFilename	=	"./.ziptmp/".uniqid("f");
			if(!$this->m_rFile	=	@fopen($this->m_sInpFilename,"w+"))
				return false;
			$this->m_oZipArchive->m_asTMPFiles[$this->m_sInpFilename]	=	$this->m_rFile;
		}
		return true;
	}
	function open() {
		if($this->m_iType==ZIP_ARCHIVE_STR_TMP||$this->m_iType==ZIP_ARCHIVE_FILE)	{
			if(!$this->m_rFile	=	@fopen($this->m_sInpFilename,"r+"))
				return false;
			$this->m_asTMPFiles[$this->m_sInpFilename]	=	$this->m_rFile;
		}
		return true;
	}
	function close() {
		if($this->m_iType==ZIP_ARCHIVE_STR_TMP||$this->m_iType==ZIP_ARCHIVE_FILE)
		{
			@fclose($this->m_sInpFilename);
			$this->m_asTMPFiles[$this->m_sInpFilename]	=	0;
		}
		return true;
	}
	function getContents() {
		switch($this->m_iType)
		{
			case	ZIP_ARCHIVE_STR		:	return $this->m_sData;	break;
			case	ZIP_ARCHIVE_STR_TMP	:	return fread($this->m_rFile,$this->m_lSize);	break;
			case	ZIP_ARCHIVE_FILE	:	if($this->m_lSize)	return fread($this->m_rFile,$this->m_lSize);	break;
			case	ZIP_ARCHIVE_STR_OFF	:	
				fseek($this->m_oZipArchive->m_rFile,$this->m_lOffset);
				$data="";
				if($this->m_lSize)
					$data=fread($this->m_oZipArchive->m_rFile,$this->m_lCSize);
				if($this->m_lSize&&$this->m_lCM==8)
					$data=gzinflate($data,$this->m_lSize);
				return $data;
				break;
			default	:	break;
		}
		return "";
	}
};

//______________________________________________________________________________



?>
<html>
		<head>
			<title>Install Script</title>
			<style type="text/css">
body,input,textarea,select,table
{
	font-family:Verdana;
	font-size:8pt;
	color:#445566;
	line-height:1.5em;
}
input.text
{
	border-width:1px;
	background-color:transparent;
	padding:1px;
	width:180px;
}
input.button
{
	width:80px;
	border:1px solid #445566;
	background-color:#667788;
	color:#ffffff;
	font-weight:900;
}
.error
{
	color:red;
	margin:6px;
	font-weight:bold;
}
fieldset
{
	border:1px solid #445566;
	background-color:#eeeeee;
}
legend
{
	border:1px solid black;
	padding:1px 12px;
	background-color:#445566;
	color:#ffffff;
	font-weight:900;
}
th
{
	text-align:left;
	padding:4px;
	width:200px;
}
td
{
	padding:4px;
}
a
{
	color:#665544;
	text-decoration:none;
	font-weight:900;
}
a:hover
{
	text-decoration:underline;
}
div.hr
{
	background-color:#445566;
	margin-top:10px;
	margin-bottom:10px;
	height:1px;
}
			</style>
		</head>
		<body>
			<h1>Install Script Version 0.0.1Beta</h1>
<?php

$error		=	false;
$meth		=	$_POST["meth"];
$pwd		=	($_POST["passwd"]!=$passwd)&&(isset($_POST["passwd"]));
$success	=	false;
$outpfile	=	$_POST["outpfile"];
$inpfile	=	$_POST["inpfile"];
$extdir		=	$_POST["extdir"];
$inpdir		=	$_POST["inpdir"];

if($pwd||!isset($_POST["passwd"]))
	$error	=	"invalid password";
if($pwd)
	sleep(2);
if(!$error&&$meth=="upload"&&!file_exists($inpfile))
	$error	=	"inpfile \"$inpfile\" does not exists";

function get_microtime()
{
    $tmp    =   microtime(false);
    $tmp    =   explode(" ",$tmp);
    return (float)$tmp[0]+(int)$tmp[1];
}

if(!$error)	//if there was no error
{
	$stime		=	get_microtime();
	if($meth=="upload")	//upload
	{
		if($extdir)
		{
			$folders	=	explode("/",$extdir);
			for($i=0; $i<sizeof($folders)-1; $i++)
			{
				$folder	=	"";
				for($i2=0; $i2<$i+1; $i2++)
				{
					if($i2)
						$folder.="/";
					$folder.=	$folders[$i2];
				}
				if(!file_exists($folder))
					mkdir($folder);
			}
		}
		$dirnum		=	0;
		$filenum	=	0;
		$list		=	"";
		$zip	=	&new CZipArchive;
		if($zip->load($inpfile))
		{
			function put_dir($data)
			{
				global $dirnum,$filenum,$list;
				$dirnum++;
				foreach($data as $row)
				{
					$list.=$GLOBALS['extdir'].$row->m_sPath."\n";
					if($row->m_iType==ZIP_ARCHIVE_DIR)
					{
						if(!file_exists($GLOBALS['extdir'].$row->m_sPath))
							mkdir($GLOBALS['extdir'].$row->m_sPath);
						put_dir($row->m_aoChilds);
					}
					else
					{
						$rFile	=	fopen($GLOBALS['extdir'].$row->m_sPath,"w+");
						fwrite($rFile,$row->getContents(),$row->m_lSize);
						$filenum++;
					}
				}
			}
			put_dir($zip->m_aoChilds);
			$zip->free();
		}
		else	//if there was an error
			$error	=	"input file is not a valid zip file!";
		echo("Extracted ".$filenum." Files and ".$dirnum." Directories in ".((get_microtime()-$stime))." Seconds<div class='hr'></div>");
	}
	if($meth=="download")	//download
	{
		if(file_exists($outpfile))
			unlink($outpfile);
		$zip		=	&new CZipArchive;
		if($_POST["cm"]=="on")
			$zip->m_lCM	=	ZIP_ARCHIVE_DEFLATE;
		$dirnum		=	0;
		$filenum	=	0;
		function read_dir($path,$secpath)
		{
			global $zip,$dirnum,$filenum;
			$dirnum++;
			$dir	=	opendir($path.$secpath);
			if($secpath)
				$zip->addDir($secpath."/");
			while($entry=readdir($dir))
			{
				if($entry[0]=="."||$entry=="..")
					continue;
				$tmp	=	"".$secpath;
				if($tmp)
					$tmp.="/";
				$tmp	.=	$entry;
				if(is_dir($path.$tmp))
					read_dir($path,$tmp);
				else
				{
					$zip->addFile($tmp,$path.$tmp);
					$filenum++;
				}
			}
		}
		read_dir($inpdir,"");
		$zip->save($outpfile,true);
		echo("Archived ".$filenum." Files and ".$dirnum." Directories in ".((get_microtime()-$stime))." Seconds<br/><a href='".$outpfile."'>".$outpfile."</a> ( ".number_format($zip->m_iSize,0,",",".")." Bytes )<div class='hr'></div>");
		$zip->free();
	}
}

?>
		<form action="index.php" method="post" name="download">
			<fieldset>
				<legend>Download</legend>
				<?php if($meth=="download"&&$pwd){ ?><div class="error">invalid password</div><?php } ?>
				<input type="hidden" name="meth" value="download" />
				<table cellspacing="0">
					<tr>
						<th><label for="passwd">Password</label></th>
						<td><input class="text" type="password" name="passwd" value="" /></td>
					</tr>
					<tr>
						<th><label for="inpdir">Input Directory</label></th>
						<td><input class="text" type="text" name="inpdir" value="<?php echo $inpdir; ?>" /></td>
					</tr>
					<tr>
						<th><label for="outpfile">Output Filename</label></th>
						<td><input class="text" type="text" name="outpfile" value="<?php echo $outpfile; ?>" /></td>
					</tr>
					<tr>
						<th><label for="cm">Compress Zip using Deflat</label></th>
						<td><input type="checkbox" name="cm" /></td>
					</tr>
					<tr>
						<th><label for="log">Log</label></th>
						<td><input type="checkbox" name="log" /></td>
					</tr>
					<tr>
						<td colspan="2">
							<input class="button" type="submit" value="generate" />
						</td>
					</tr>
				</table>
			</fieldset>
		</form>
		<form action="index.php" method="post" name="upload">
			<fieldset>
				<legend>Upload</legend>
				<?php if($meth=="upload"&&$error){ ?><div class="error"><?php echo $error; ?></div><?php } ?>
				<input type="hidden" name="meth" value="upload" />
				<table cellspacing="0">
					<tr>
						<th><label for="passwd">Password</label></th>
						<td><input class="text" type="password" name="passwd" value="" /></td>
					</tr>
					<tr>
						<th><label for="extdir">Extraction Directory</label></th>
						<td><input class="text" type="text" name="extdir" value="<?php echo $extdir; ?>" /></td>
					</tr>
					<tr>
						<th><label for="inpfile">Input Filename</label></th>
						<td><input class="text" type="text" name="inpfile" value="<?php echo $inpfile; ?>" /></td>
					</tr>
					<tr>
						<th><label for="log">Log</label></th>
						<td><input type="checkbox" name="log" /></td>
					</tr>
					<tr>
						<td colspan="2">
							<input class="button" type="submit" value="extract" />
						</td>
					</tr>
				</table>
			</fieldset>
		</form>
		<div id="subline">
			copyright&copy; 2006 by Florian Ha�ann
		</div>
		<?php
		if($_POST["log"]=="on")
		{
			if($_POST["meth"]=="upload")
				echo("<h2>Log</h2>".nl2br($list));
			elseif($_POST["meth"]=="download")
				echo("<h2>Log</h2>".nl2br($zip->m_sLog));
		}
		?>
	</body>
</html>