<?php
	
	class Compare {
		
		private static $_result;
		
		const typeNone = 0;
		const typeAdd = 1;
		const typeRemove = 2;
		
		public static function diff($x, $y, $patch = true){
			
			self::$_result = array();
			
			$table = self::_longestCommonSubsequence($x, $y);
			self::_createDiff($table, $x, $y, self::_getLength($x), self::_getLength($y));
			
			if($patch){
				$result = array();
				$typeNone = 0;
				$infoLine = null;
				
				foreach(self::$_result as $num => $content){
					if($content['type']!= self::typeNone){
						if($infoLine === null){
							$infoLine = count($result);
							$result[]= array(1, 1, 1, 1);
							
							if($typeNone != 0){
								$result[$infoLine][0]= self::$_result[$num -(($typeNone > 3)? 3:$typeNone)]['line'][0]+ 1;
								$result[$infoLine][2]= self::$_result[$num -(($typeNone > 3)? 3:$typeNone)]['line'][1]+ 1;
								
								for($i = 0; $i <(($typeNone > 3)? 3:$typeNone); $i ++){
									$result[]= self::$_result[$num -($i + 1)]['text'];
									$result[$infoLine][1]++;
									$result[$infoLine][3]++;
								}
							}
						}
						
						if($content['type']== self::typeAdd){
							$result[]= '+' . $content['text']; 
							$result[$infoLine][3]++;
						} else {
							$result[]= '-' . $content['text']; 
							$result[$infoLine][1]++;
						}
						
						$typeNone = 0;
					} else {
						$typeNone ++;
						
						if($infoLine !== null){
							$result[]= $content['text'];
							$result[$infoLine][1]++;
							$result[$infoLine][3]++;
						}
						
						if($typeNone == 3 and $infoLine !== null){
							$typeNone = 0;
							//@@ -{start in old file},{lenght remove + length none} +{start in new file},{length add + length none} @@
							$result[$infoLine]= '@@ -' . $result[$infoLine][0]. ',' . $result[$infoLine][1]. ' +' . $result[$infoLine][2]. ',' . $result[$infoLine][3]. ' @@';
							$infoLine = null;
						}
					}
				}
				
				if($infoLine !== null){
					$result[$infoLine]= '@@ -' . $result[$infoLine][0]. ',' . $result[$infoLine][1]. ' +' . $result[$infoLine][2]. ',' . $result[$infoLine][3]. ' @@';
				}
				
				return $result;
			}
			
			return self::$_result;
			
		}
		
		public static function patch($file, $patch){
			
		}
		
		private static function _createDiff($table, $x, $y, $i, $j){
			
			if($i > 0 and $j > 0 and $x[$i - 1]== $y[$j - 1]){
				self::_createDiff($table, $x, $y, $i - 1, $j - 1);
				self::$_result[]= array('text' => $x[$i - 1], 'type' => self::typeNone, 'line' => array($i, $j));
			} else {
				if($j > 0 and($i == 0 or(!empty($table[$i][$j - 1])? $table[$i][$j - 1]:0)>=(!empty($table[$i - 1][$j])? $table[$i - 1][$j]:0))){
					self::_createDiff($table, $x, $y, $i, $j - 1);
					self::$_result[]= array('text' => $y[$j - 1], 'type' => self::typeAdd, 'line' => $j);
				} elseif($i > 0 and($j == 0 or(!empty($table[$i][$j - 1])? $table[$i][$j - 1]:0)<(!empty($table[$i - 1][$j])? $table[$i - 1][$j]:0))){
					self::_createDiff($table, $x, $y, $i - 1, $j);
					self::$_result[]= array('text' => $x[$i - 1], 'type' => self::typeRemove, 'line' => $i);
				}
			}
			
		}
		
		private static function _longestCommonSubsequence($x, $y){
			
			$xLength = self::_getLength($x);
			$yLenght = self::_getLength($y);
			$table = array();
			
			for($i = 0; $i < $xLength; $i ++){
				for($j = 0; $j < $yLenght; $j ++){
					if($i != 0 and $j != 0 and trim($x[($i - 1 > 0)? $i - 1:0])== trim($y[($j - 1 > 0)? $j - 1:0])){
						$table[$i][$j]= $table[($i - 1 > 0)? $i - 1:0][($j - 1 > 0)? $j - 1:0]+ 1;
					} else {
						$table[$i][$j]= max(($j == 0)? 0:$table[$i][$j - 1],($i == 0)? 0:$table[$i - 1][$j]);
					}
				}
			}
			
			return $table;
			
		}
		
		private static function _getLength($var){
			
			if(gettype($var)== 'string'){
				return strlen($var);
			} elseif(gettype($var)== 'array'){
				return count($var);
			} else {
				return false;
			}
			
		}
		
	}
	
?>