<?php
/*--------------------------------------------------
 | TAR/GZIP/ZIP ARCHIVE CLASSES
 | By Devin Doucette
 | Copyright (c) 2003 Devin Doucette
 | Email: darksnoopy@shaw.ca
 +--------------------------------------------------
 | Email bugs/suggestions to darksnoopy@shaw.ca
 +--------------------------------------------------
 | This script has been created and released under
 | the GNU GPL and is free to use and redistribute
 | only if this copyright statement is not removed
 +--------------------------------------------------*/



   class zipfile extends archive
   {
        var $cwd = "./";
        var $comment = "";
        var $level = 9;
        var $offset = 0;
        var $recursesd = 1;
        var $storepath = 1;
        var $replacetime = 0;
        var $central = array();
        var $zipdata = array();

	function zipfile ($cwd = "./", $flags = array())
        {
                 $this->cwd = $cwd;
		 if(isset($flags['time'])) $this -> replacetime = $flags['time'];
		 if(isset($flags['recursesd'])) $this -> recursesd = $flags['recursesd'];
		 if(isset($flags['storepath'])) $this -> storepath = $flags['storepath'];
		 if(isset($flags['level'])) $this -> level = $flags['level'];
		 if(isset($flags['comment'])) $this -> comment = $flags['comment'];
                 $this->archive($flags);
	}

	function addfile($data, $filename, $flags=array())
        {
		if($this->storepath != 1)
                {
                     $filename = strstr ($filename,"/") ? substr ($filename, strrpos ($filename,"/") + 1) : $filename;
                }
		else
                {
                     $filename = preg_replace("/^(\.{1,2}(\/|\\\))+/","", $filename);
                }

		$mtime = !empty($this -> replacetime) ? getdate ($this->replacetime) : (isset ($flags['time']) ? getdate($flags['time']) : getdate());
		$mtime = preg_replace("/(..){1}(..){1}(..){1}(..){1}/","\\x\\4\\x\\3\\x\\2\\x\\1",dechex(($mtime['year']-1980<<25)|($mtime['mon']<<21)|($mtime['mday']<<16)|($mtime['hours']<<11)|($mtime['minutes']<<5)|($mtime['seconds']>>1)));
		eval('$mtime = "'.$mtime.'";');

		$crc32 = crc32($data);
		$normlength = strlen($data);
		$data = gzcompress($data,$this->level);
		$data = substr($data,2,strlen($data)-6);
		$complength = strlen($data);

		$temp = "\x50\x4b\x03\x04\x14\x00\x00\x00\x08\x00".$mtime.pack("VVVvv",$crc32,$complength,$normlength,strlen($filename),0x00).$filename.$data.pack("VVV",$crc32,$complength,$normlength);
		$this -> zipdata[] = $temp;
		$this -> central[] = "\x50\x4b\x01\x02\x00\x00\x14\x00\x00\x00\x08\x00".$mtime.pack("VVVvvvvvVV",$crc32,$complength,$normlength,strlen($filename),0x00,0x00,0x00,0x00,0x0000,$this->offset).$filename;

		$this -> offset = $this->offset + strlen($temp);
	}

	function addfiles($filelist)
        {
		$pwd = getcwd();
		@chdir($this->cwd);

		foreach($filelist as $current)
                {
			if(!@file_exists($current)) continue;

			$stat = stat($current);

			if($fp = @fopen($current,"rb"))
                        {
				$data = fread($fp,$stat[7]);
				fclose($fp);
			}
			else
                        {
				$data = "";
                        }
			$flags = array('time'=>$stat[9]);

			$this -> addfile($data,$current,$flags);
		}

		@chdir($pwd);
	}

	function getdata()
        {
		$central = implode("",$this->central);
		$zipdata = implode("",$this->zipdata);
		return $zipdata.$central."\x50\x4b\x05\x06\x00\x00\x00\x00".pack("vvVVv",sizeof($this -> central),sizeof($this -> central),strlen($central),strlen($zipdata),strlen($this -> comment)).$this->comment;
	}

	function filedownload($filename)
        {
                //header("Content-type: application/force-download");
                //header("Content-type: application/octetstream");
                @header("Content-type: application/x-zip-compressed");
		@header("Content-disposition: attachment; filename=$filename");

                echo ($this -> getdata());
	}
   }

   class archive
   {
	var $overwrite		= 0;
	var $defaultperms	= 0644;

	function archive($flags=array())
        {
		if(isset($flags['overwrite'])) $this -> overwrite = $flags['overwrite'];
		if(isset($flags['defaultperms'])) $this -> defaultperms = $flags['defaultperms'];
	}

	function adddirectories($dirlist)
        {
		$pwd = getcwd();
		@chdir($this->cwd);

		$filelist = array();

		foreach($dirlist as $current)
                {
                    if(@is_dir($current))
                    {
                        $temp = $this->parsedirectories($current);
		        foreach($temp as $filename)
                        {
                          $filelist[] = $filename;
                        }
                    }
		    else if(@file_exists($current))
                    {
                        $filelist[] = $current;
                    }
		}

		@chdir($pwd);
		$this -> addfiles($filelist);
	}

	function parsedirectories($dirname)
        {
		$filelist = array();
		$dir = @opendir($dirname);

		while($file = @readdir($dir))
                {
                    if($file == "." || $file == "..")
                    {
                         continue;
                    }
                    else if(@is_dir($dirname."/".$file))
                    {
		         if($this->recursesd != 1) continue;
		         $temp = $this->parsedirectories($dirname."/".$file);
		         foreach($temp as $file2)
                         {
                           $filelist[] = $file2;
                         }
                    }
		    else if(@file_exists($dirname."/".$file))
                    {
                         $filelist[] = $dirname."/".$file;
                    }
		}

		@closedir($dir);

		return $filelist;
	}

	function filewrite($filename,$perms=null)
        {
		if($this->overwrite != 1 && @file_exists($filename)) return $this->error("File $filename already exists.");

		if(@file_exists($filename)) @unlink($filename);

		$fp = @fopen($filename,"wb");

		if(!fwrite($fp,$this->getdata())) return $this->error("Could not write data to $filename.");

		@fclose($fp);

		if(!isset($perms)) $perms = $this->defaultperms;

		@chmod($filename,$perms);
	}

	function extractfile($filename)
        {
		if($fp = @fopen($filename,"rb"))
                {
			return $this->extract(fread($fp,filesize($filename)));
			@fclose($fp);
		}
		else
                {
			return $this->error("Could not open $filename.");
                }
	}

	function error($error)
        {
		$this->errors[] = $error;
		return 0;
	}
   }
?>