<?php

	$time = microtime ( true );
	
	$original = imagecreatefromjpeg ( 'image3.jpg' );
	$image = imagecreatetruecolor ( imagesx ( $original ), imagesy ( $original ) * 1.3 );
	$originalX = imagesx ( $original );
	$originalY = imagesy ( $original );
	$imageX = imagesx ( $image );
	$imageY = imagesy ( $image );
	
	imagecopyresized ( $image, $original, 0, 0, 0, 0, $originalX, $originalY, $originalX, $originalY );
	
	$alpha = 50;
	
	for ( $y = $originalY; $y < $imageY; $y ++ ) {
		for ( $x = 0; $x < $imageX; $x ++ ) {
			
			$color = imagecolorat ( $image, $x - 1, ( $imageY - $y ) + ( 0.7 * $originalY ) );
			$newColor = imagecolorallocatealpha ( $image, ( $color & 0xFF0000 ) >> 16, ( $color & 0x00FF00 ) >> 8, ( $color & 0x0000FF ), $alpha );
			
			imagesetpixel ( $image, $x, $y, $newColor );
		}
		
		$alpha += ( 100 / ( $originalY * 0.3 ) );
	}
	
	imagettftext ( $image, 10, 0, 5, 15, imagecolorallocate ( $image, 255, 255, 255 ), 'arial.ttf', 'Zeit: ' . round ( microtime ( true ) - $time, 4 ) . 'sec' );
	
	header( 'Content-type: image/jpeg' ); 
	imagejpeg ( $image );	
	
?>