AutoUpdater = Class.create({
	
	_elBaseInput : null,
	
	_objAjaxRequest : null,
	
	_strResultListHtmlId : '__AutoUpdateResult',
	
	_elResultList : null,
	
	_elActiveListItem : null,
	
	_arrCachedResult : null,
	
	initialize : function(elBaseInput)
	{
		this._elBaseInput = elBaseInput;
		this._elBaseInput.observe('keyup', this.fetchData.bindAsEventListener(this));
	},
	
	
	getResultList : function()
	{
		if(! Object.isElement(this._elResultList) )
			this._elResultList = $(this._strResultListHtmlId);
			
		return this._elResultList;
	},
	
	
	getActiveListItem : function()
	{
		return this._elActiveListItem;
	},
	
	
	fetchData : function(objEvent)
	{
		switch( objEvent.keyCode )
		{
			case Event.KEY_BACKSPACE :
				this.listResult();
				return;
			break;
			
			case Event.KEY_RETURN :
				var elActiveListItem = this.getActiveListItem();
				if( Object.isElement(elActiveListItem) )
				{
					this._elBaseInput.setValue(elActiveListItem.readAttribute('accountnr'));
					
					var elNameInput = $$('input.autoupdate.name').first();
					if( Object.isElement(elNameInput) )
						elNameInput.setValue(elActiveListItem.readAttribute('accountOwner'));
				}
				
				var elResultList = this.getResultList();
				if( Object.isElement(elResultList) )
					elResultList.hide();
			break;
			
			case Event.KEY_UP :
			case Event.KEY_DOWN :
				this.toggleActiveListItem(objEvent.keyCode);
			break;
			
			default :
				if( this._objAjaxRequest !== null )
					return;
				
				var strAccountNr = $F(this._elBaseInput);
				this._objAjaxRequest = new Ajax.Request('autoupdate.php', {
					parameters : {kto_nr : strAccountNr},
					onSuccess  : function(objResponse)
					{
						this._objAjaxRequest = null;
						
						var objData = objResponse.responseText.evalJSON();
						this.listResult(objData);
					}.bind(this)
				});
			break;
		}
	},
	
	
	listResult : function( arrResult )
	{
		arrResult = Object.isUndefined(arrResult) ? this._arrCachedResult : arrResult;
		
		if( !Object.isArray(arrResult) || (Object.isArray(arrResult) && arrResult.size() === 0) )
			return;
		
		this._arrCachedResult = arrResult;
		var elDiv = this.getResultList(), elUl = null;
		if(! Object.isElement(elDiv) )
		{
			elDiv = new Element('div', {id : this._strResultListHtmlId, style : 'position:absolute;'}).addClassName('au');
			elUl = new Element('ul');
			elDiv.insert(elUl);
			
			$$('body').first().insert(elDiv);
		}
		
		if(! Object.isElement(elUl) ) 
		{
			elUl = elDiv.select('ul').first();
			
			if( !elUl.empty() ) 
			{
				var elUlCloned = elUl.cloneNode(false);
	  		elUl.replace(elUlCloned);
				elUl = elUlCloned;
	  	}
		}
		
		arrResult.each(function(objAccount){
			elUl.insert(new Element('li', {accountNr : objAccount.kto_nr, accountOwner : objAccount.name}).update(objAccount.name));
		}.bind(this));
		
		var arrPosition = this._elBaseInput.viewportOffset();
		elDiv.setStyle({
			top : (arrPosition[1]+this._elBaseInput.getHeight()) + 'px',
			left : (arrPosition[0]-2) + 'px',
			display : 'block',
			width : this._elBaseInput.getWidth() + 'px'
		});
	},
	
	
	toggleActiveListItem : function(intMode)
	{
		var elResultList = this.getResultList();
		if(! Object.isElement(elResultList) )
			return;
			
		var elActive = elResultList.select('li.active').first();
		if( Object.isElement(elActive) )
			elActive.removeClassName('active');
		
		switch( intMode )
		{
			case Event.KEY_UP :
				if(! Object.isElement(elActive) )
					elActive = elResultList.select('li:last-child').first();
				else
				{
					if(! Object.isElement((elActive = elActive.previous())) )
						elActive = elResultList.select('li:last-child').first();
				}
			break;
			
			case Event.KEY_DOWN :
				if(! Object.isElement(elActive) )
					elActive = elResultList.select('li:first-child').first();
				else
				{
					if(! Object.isElement((elActive = elActive.next())) )
						elActive = elResultList.select('li:first-child').first();
				}
			break;
		}
		
		if( Object.isElement(elActive) ) 
		{
			this._elActiveListItem = elActive;
			elActive.addClassName('active');
		}
	}
});

document.observe('dom:loaded', function(){
	$$('input.autoupdate').each(function(el){
		new AutoUpdater(el);		
	});
});