﻿
 /****************************************************************************************
  * Ajax-basiertes Script fuer erweiterte Suchfunktionialitaet
  * bei "Suchen und Buchen"
  *
  * @package   Snowtrex
  * @author    Peter Kropff <p.kropff@elpix.de>
  * @copyright 2007 elpix GmbH
  * @version   1.7 Beta 3 (Stand 19 Maerz 2007)
  *************************************************************************************** /

 /*****************************************************************************************
  * Konstruktormethode zur Objekterzeugung
  * @param fields
  * @var array
  */
  function advancedSearch (fields)
  {
   /**
    * Formularname
    * @var object
    */
    var form = document.suchenundbuchen;

   /**
    * Namen der Select-Felder
    * @var array
    */
    var fields = fields;

   /**
    * Ausgewaehltes Select-Feld
    * @var string
    */
    var activeOption;

   /**
    * Array zur Erfassung aller erlaubten Inhalte
    * @var array
    */
    var found = new Array ();

   /**
    * Array zur Werte-Erfassung der Select-Felder
    * @var array
    */
    var select = new Array ();   
    
   /**
    * Variablen zur erstmaligen Erfassung von
    * "Alle Verpflegungsarten" bzw. Eigenanreise und Übernachtungen
    * @var string
    */
    var verpfl_lang;
    var dauer_lang;
    var anr_lang;
    var pers_lang;
    
   /**
    * Variable für POST-Übermittlung Ajax-Request
    */
    var str;

   /*****************************************************************************************
    * Anfang oeffentliche Hauptmethode zur Steuerung der Ein- und Ausgaben
    *****************************************************************************************/
    this.startSearch = function ()
    { 
     /**
      * Setzen der Select-Werte in Array "select"
      */
      for (i in fields)
      {
        if (form[fields[i]].selectedIndex > -1)
        {
          select[fields[i]] = form[fields[i]].options[form[fields[i]].selectedIndex].value;
        }
        else
        {
          select[fields[i]] = '0';
        }
      }

     /**
      * Wenn Laendertrennstrich bei den Reisezielen ausgewaelht wird
      */
      if (select['ziel'].match (/_/))
      {
        select['ziel'] = select['ziel'].substr(0, select['ziel'].length - 2);
      }
      
     /**
      * Spracheinträge für die entsprechenden Select-Felder holen,
      * da nicht im JS-Arrays
      */ 
      if (form.erwachsene)
      {
        if (typeof form.erwachsene.options != 'undefined')
        {
          pers_lang = form.erwachsene.options[0].firstChild.nodeValue;
        }
      }
      if (form.dauer)
      {
        if (typeof form.dauer.options != 'undefined')
        {
          dauer_lang = form.dauer.options[0].firstChild.nodeValue;
        }
      }
      if (form.verpflegung)
      {
        if (typeof form.verpflegung.options != 'undefined')
        {
          verpfl_lang = form.verpflegung.options[0].firstChild.nodeValue;
        }
      }
      if (form.abreise)
      {
        if (typeof form.abreise.options != 'undefined')
        {
          anr_lang = form.abreise.options[0].firstChild.nodeValue;
        }
      }
      
      for (i in select)
      {
        if (i != 'verpflegung' && i != 'abreise')
        {
          if (select[i] != 0)
          {
            str += '&' + i + '=' + select[i];
          }
        }
        else if (i == 'verpflegung')
        {
          if (select[i] != '1')
          {
            str += '&' + i + '=' + select[i];
          }
        }
        else if (i == 'abreise')
        {
          if (select[i] != 'EIG')
          {
            str += '&' + i + '=' + select[i];
          }
        }
      }
      prepareRequest();
    }
   /****************************************************************************************
    * Ende oeffentliche Hauptmethode zur Steuerung der Ein- und Ausgaben
    ****************************************************************************************/


   /****************************************************************************************
    * Anfang Ajax-Methoden, zum Auslesen erlaubter Inhalte pro Rubrik
    ****************************************************************************************/
    function prepareRequest()
    {
     /**
      * Überprüfung auf Internet Explorer
      * da Opera aber auch document.all zu kennen scheint, Ausschlusscheck
      */
      if (document.all && !navigator.userAgent.match(/Opera/))
      {
        try
        {
          ajax_obj = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch (exp)
        {
          try
          {
            ajax_obj = new ActiveXObject("Microsoft.XMLHTTP");
          }
          catch (none) { }
        }      
      }
      else
      {
        ajax_obj = new XMLHttpRequest();
      }    
      if (ajax_obj)
      { 
       /**
        * eigentlichen Request auslösen
        */
        sendRequest();
      }      
    }
    
    function sendRequest()
    {
     /**
      * Für die Dauer der Übertragung alle Select-Felder auf "disable" setzen,
      * um falsche Informationen zu vermeiden
      */
      for (i in select)
      {
        form[i].setAttribute ('disabled', true);
      }
      
     /**
      * parseInt(Math.random() * 999999) um IE am Cachen zu hindern
      */
      try
      {
        ajax_obj.open (
                        'POST',                    
                        'getinfos.php?rand=' + parseInt(Math.random() * 999999), 
                        true
                      ); 
       /**
        * Da Daten per POST versendet werden, muss vorher ein Formular-Header gesendet werden
        */
        ajax_obj.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        ajax_obj.send(str);     
        ajax_obj.onreadystatechange = function ()
        {  
         /**
          * Wenn Request vollständig abgeschlossen ist...
          */
          if (ajax_obj.readyState == 4 && ajax_obj.status == 200)
          {            
           /**
            * Hier unbedingt mit responseXML arbeiten, da IE bei responseText Fehler auswirft
            */
            xml = ajax_obj.responseXML; 
            analyseXML ();
          }
        }
      }
      catch (e)
      {
        alert (e);
        //location.reload();
      }
    }
   
    function analyseXML ()
    {
     /**
      * WICHTIG! keine Variablennamen nehmen, die gleichzeitig Tags im XML-Dokument sind
      * da macht der IE nicht mit und wirft Fehler aus
      */
      res_laender = xml.getElementsByTagName('land')[0].firstChild.nodeValue.split(',');
      res_ziele = xml.getElementsByTagName('ziel')[0].firstChild.nodeValue.split(',');
      res_datum = xml.getElementsByTagName('datum')[0].firstChild.nodeValue.split(',');
      res_dauer = xml.getElementsByTagName('dauer')[0].firstChild.nodeValue.split(',');
      res_erw = xml.getElementsByTagName('erwachsene')[0].firstChild.nodeValue.split(',');
      res_mampf = xml.getElementsByTagName('verpflegung')[0].firstChild.nodeValue.split(',');
      res_anreise = xml.getElementsByTagName('abreise')[0].firstChild.nodeValue.split(',');
      
      getCountries (res_laender);      
      getPlaces (res_ziele);
      getDates(res_datum);
      getNights (res_dauer);
      getPersons (res_erw);
      getCaterings (res_mampf);
      getTravelModes (res_anreise);
      
     /**
      * Nachdem alle Methoden ausgeführt worden sind,
      * disabled für alle Felder zurücknehmen
      */
      for (i in select)
      {
        form[i].removeAttribute ('disabled');
      }
    }
      
   /****************************************************************************************
    * Anfang Methoden für Verarbeitung der XML-Daten
    ***************************************************************************************/
    
    function getCountries (res_laender)
    {
      found['land'] = new Array ();
      if (res_laender.length > 1)
      {
        found['land'][0] = 'L0';
      }
      for (i in res_laender)
      {
        found['land'].push('L' + res_laender[i])
      }
      setCountries();
    }
    
    function getPlaces (res_ziele)
    {
     /**
      * Gefunden Länder durchlaufen und Einträge in found['ziel'] einbauen
      * dazu temporäres Array aufbauen
      */
      found['ziel'] = new Array ();
      for (i in found['land'])
      {
       /**
        * Ländertrennstriche aus Array Ziele holen
        */
        index = 'Z' + found['land'][i].replace ('L','');
        if ('Z0' != index)
        {
          found['ziel'].push(index + '_0');
          found['ziel'].push(index);
          found['ziel'].push(index + '_1');
          for (j in res_ziele)
          {
            if (in_array (res_ziele[j], ortzuland[found['land'][i]]))
            {
              found['ziel'].push('Z' + res_ziele[j]);
            }
          }
        }
      }
      setPlaces();
    }
    
    function getDates (res_datum)
    {
     /**
      * Gefunden Länder durchlaufen und Einträge in found['ziel'] einbauen
      * dazu temporäres Array aufbauen
      */
      found['datum'] = new Array ();
      /*for (i in termine)
      {
       
        if ('Z0' != index)
        {
          found['ziel'].push(index + '_0');
          found['ziel'].push(index);
          found['ziel'].push(index + '_1');
          for (j in res_ziele)
          {
            if (in_array (res_ziele[j], ortzuland[found['land'][i]]))
            {
              found['ziel'].push('Z' + res_ziele[j]);
            }
          }
        }
      }
      //setDates();*/
    }
    
    function getNights (res_dauer)
    {
      found['dauer'] = new Array ();
      for (i in res_dauer)
      {
        found['dauer'].push(res_dauer[i])
      }
      setNights();
    }
    
    function getPersons (res_erw)
    {
      found['persons'] = new Array ();
      for (i in res_erw)
      {
        found['persons'].push(res_erw[i])
      }
      setPersons();
    }
    
    function getCaterings (res_mampf)
    {
      found['verpflegung'] = new Array ();
      for (i in res_mampf)
      {
        found['verpflegung'].push(res_mampf[i])
      }
      setCaterings();
    }
    
    function getTravelModes (res_anreise)
    {
      found['abreise'] = new Array ();
      for (i in res_anreise)
      {
        found['abreise'].push(res_anreise[i])
      }
      setTravelModes();
    }
    
   /****************************************************************************************
    * Ende Methoden für Verarbeitung der XML-Daten
    ***************************************************************************************/

    
   /****************************************************************************************
    * Anfang Verarbeitungsmethoden fuer die jeweiligen Arrays
    ***************************************************************************************/

    function setPlaces ()
    {
     /**
      * Aufruf Hilfsmethode zum entfernen aller option-Felder
      */
      clearSelects ('ziel');

     /**
      * Kein Land ausgewaehlt, Ausgabe von "Alle Reiseziele"
      * suff_ziel = Z
      */
      
      if (select['land'] == 0)
      {
        opt = document.createElement('option');
        eingabe = document.createTextNode (ziele['Z0']);
        opt.appendChild (eingabe);
        opt.setAttribute('value', '0');
        form.ziel.appendChild(opt);
      }
      for (i = 0; i < found['ziel'].length; i++)
      {
        opt = document.createElement('option');
        eingabe = document.createTextNode (ziele[found['ziel'][i]]);
        opt.appendChild (eingabe);
        opt.setAttribute('value', found['ziel'][i].replace('Z',''));
       /**
        * ausgewaehltes Element auf selected setzen
        */
        if (select['ziel'] == found['ziel'][i].replace('Z',''))
        {
          opt.setAttribute('selected', 'selected');
          select['ziel'] = found['ziel'][i].replace('Z','');
        }
        else if (select['land'] == found['ziel'][i].replace('Z',''))
        {
          opt.setAttribute('selected', 'selected');
          select['ziel'] = found['ziel'][i].replace('Z','');
        }
        form.ziel.appendChild(opt);
      }  
    }

    function setCountries ()
    {
     /**
      * Aufruf Hilfsmethode zum entfernen aller option-Felder
      */
      clearSelects ('land');

     /**
      * Ausgabe aller Laender aus temporaerem Array "arr"
      * suff_land = L
      */
      for (i in found['land'])
      {
        opt = document.createElement('option');
        eingabe = document.createTextNode (laender[found['land'][i]]);
        opt.appendChild (eingabe);
        opt.setAttribute('value', found['land'][i].replace (/L/,''));
       /**
        * ausgewaehtes Element auf selected setzen
        */
        if (select['land'] == found['land'][i].replace (/L/,''))
        {
          opt.setAttribute('selected', 'selected');
          select['land'] = found['land'][i].replace (/L/,'');
        }
        form.land.appendChild(opt);
      }
    }

    function setCaterings ()
    {
      if (typeof form.verpflegung.options != 'undefined')
      {
       /**
        * Aufruf Hilfsmethode zum entfernen aller option-Felder
        */
        clearSelects ('verpflegung');

       /**
        * Setzen Standardeintrag, da im Array "verpflegungen" nicht vorhanden
        */
        opt = document.createElement('option');
        eingabe = document.createTextNode (verpfl_lang);
        opt.appendChild (eingabe);
        opt.setAttribute('value', '1');
        form.verpflegung.appendChild(opt);

       /**
        * Ausgabe aller Verpflegungsarten aus Array "found['verpflegung']"
        */
        for (i = 0; i < found['verpflegung'].length; i++)
        {
         /**
          * Ausnahmedefinition fuer moegliche doppelte Eintraege
          */
          if (found['verpflegung'][i] == found['verpflegung'][(i - 1)])
          {
            continue;
          }
          opt = document.createElement('option');
          eingabe = document.createTextNode (verpflegungen[found['verpflegung'][i]]);
          opt.appendChild (eingabe);
          opt.setAttribute('value', found['verpflegung'][i]);
         /**
          * ausgewaehltes Element auf selected setzen
          */
          if (select['verpflegung'] == found['verpflegung'][i])
          {
            opt.setAttribute('selected', 'selected');
            select['verpflegung'] = found['verpflegung'][i];
          }
          form.verpflegung.appendChild(opt);
        }
      }
    }

    function setTravelModes ()
    {
     /**
      * Aufruf Hilfsmethode zum entfernen aller option-Felder
      */
      if (typeof form.abreise.options != 'undefined')
      {
        clearSelects ('abreise');

       /**
        * Setzen Standardeintrag, da im Array "abreise" nicht vorhanden
        */
        opt = document.createElement('option');
        eingabe = document.createTextNode (anr_lang);
        opt.appendChild (eingabe);
        opt.setAttribute('value', 'EIG');
        form.abreise.appendChild(opt);

       /**
        * Ausgabe aller Verpflegungsarten aus Array "found['abreise']"
        */
        for (i in found['abreise'])
        {
          opt = document.createElement('option');
          eingabe = document.createTextNode (abreise[found['abreise'][i]]);
          opt.appendChild (eingabe);
          opt.setAttribute('value', found['abreise'][i]);
         /**
          * ausgewaehltes Element auf selected setzen
          */
          if (select['abreise'] == found['abreise'][i])
          {
            opt.setAttribute('selected', 'selected');
            select['abreise'] = found['abreise'][i];
          }
          form.abreise.appendChild(opt);
        }
      }
    }

    function setDates ()
    {
     /**
      * Aufruf Hilfsmethode zum entfernen aller optgroup-Elemente
      */
      clearOptgroup();
      clearSelects ('datum');
      auswahl = document.createElement('option');
      eingabe = document.createTextNode (terminauswahl);
      auswahl.appendChild (eingabe);
      auswahl.setAttribute('value', '0');
      form.datum.appendChild(auswahl);
     /**
      * Ausgabe aller Datumsangaben aus Array "placeToDate"
      */
      for (i in found['datum'])
      {
       /**
        * Wenn Monatseintrag vorhanden ist
        */
        if (typeof found['datum'][i]['label'] != 'undefined')
        {
         /**
          * optgroup-Element
          * Label-Wert fuer optgroup-Element setzen
          */
          optgr = document.createElement('optgroup');
          optgr.setAttribute('label', found['datum'][i]['label']);
         /**
          * Datumsangaben pro Monat auflisten
          */
          for (j = 0; j < found['datum'][i]['data'].length; j++)
          {
           /**
            * opt                 -> Erzeugung neues option-Element
            * eingabe             -> Text des option-Elements
            * opt.appendChild     -> Textknoten in option einhaengen
            * opt.setAttribute    -> value von option setzen
            * optgr.appendChild   -> option in optgroup einhaengen
            */
            if (typeof found['datum'][i]['data'][j] != 'undefined')
            {
              opt = document.createElement('option');
              eingabe = document.createTextNode (found['datum'][i]['data'][j][0]);
              opt.appendChild (eingabe);
              opt.setAttribute('value', found['datum'][i]['data'][j][1]);
              if (found['datum'][i]['data'][j][1] == select['datum'])
              {
                opt.setAttribute('selected', true);
              }
              optgr.appendChild(opt);
            }
          }

         /**
          * optgroup-Element in Select-Feld einhaengen
          */
          form.datum.appendChild(optgr);
        }
      }
    }

    function setNights ()
    {
     /**
      * Aufruf Hilfsmethode zum entfernen aller option-Felder
      */
      clearSelects ('dauer');
     /**
      * Setzen Standardeintrag, da im Array "dauer" nicht vorhanden
      */
      opt = document.createElement('option');
      eingabe = document.createTextNode (dauer_lang);
      opt.appendChild (eingabe);
      opt.setAttribute('value', '0');
      form.dauer.appendChild(opt);
          
      for (i in found['dauer'])
      {
        opt = document.createElement('option');
        eingabe = document.createTextNode (found['dauer'][i]);
        opt.appendChild (eingabe);
        opt.setAttribute('value', found['dauer'][i]);
       /**
        * ausgewaehtes Element auf selected setzen
        */
        if (select['dauer'] == found['dauer'][i])
        {
          opt.setAttribute('selected', 'selected');
          select['dauer'] = found['dauer'][i];
        }
        form.dauer.appendChild(opt);
      }
    }

    function setPersons ()
    {
     /**
      * Aufruf Hilfsmethode zum entfernen aller option-Felder
      */
      clearSelects ('erwachsene');
     /**
      * Setzen Standardeintrag, da im Array  nicht vorhanden
      */
      opt = document.createElement('option');
      eingabe = document.createTextNode (pers_lang);
      opt.appendChild (eingabe);
      opt.setAttribute('value', '0');
      form.erwachsene.appendChild(opt);
      for (i in found['persons'])
      {
        opt = document.createElement('option');
        eingabe = document.createTextNode (found['persons'][i]);
        opt.appendChild (eingabe);
        opt.setAttribute('value', parseInt (found['persons'][i]));
       /**
        * ausgewaehtes Element auf selected setzen
        */
        if (select['erwachsene'] == parseInt (found['persons'][i]))
        {
          opt.setAttribute('selected', 'selected');
          select['erwachsene'] = parseInt (found['persons'][i]);
        }
        form.erwachsene.appendChild(opt);
      }
    }
    
   /****************************************************************************************
    * Ende Verarbeitungsmethoden fuer die jeweiligen Arrays
    ***************************************************************************************/


   /****************************************************************************************
    * Anfang Hilfsmethoden
    ***************************************************************************************/

    function clearSelects (select)
    {
      num = form[select].childNodes.length;
      for (i = 0; i < num; i++)
      {
        child = form[select].childNodes[0];
        form[select].removeChild(child);
      }
      form[select].length = 0;
    }

    function clearOptgroup ()
    {
      num = document.getElementsByTagName("optgroup").length;
      for (i = 0; i < num; i++)
      {
        optgroup = document.getElementsByTagName("optgroup")[0];
        form.datum.removeChild(optgroup);
      }
    }

    function in_array (item, arr)
    {
      if (typeof arr != 'undefined')
      {
        for (z in arr)
        {          
          if (item == arr[z])
          {
            return true;
            break;
          }          
        }
        return false;
      }
    }

   /****************************************************************************************
    * Ende Hilfsmethoden
    ***************************************************************************************/
  }
 /** Ende Objekt
  ***************************************************************************************/


 /****************************************************************************************
  * Definition globaler Variablen und Objektreferenz
  */

 /**
  * Namen aller Select-Felder
  * @var array
  */
  var select_fields = new Array ();

  if (document.suchenundbuchen.land)
  {
    select_fields.push ('land');
  }
  if (document.suchenundbuchen.ziel)
  {
    select_fields.push ('ziel');
  }
  if (document.suchenundbuchen.datum)
  {
    select_fields.push ('datum');
  }
  if (document.suchenundbuchen.dauer)
  {
    select_fields.push ('dauer');
  }
  if (document.suchenundbuchen.erwachsene)
  {
    select_fields.push ('erwachsene');
  }
  if (document.suchenundbuchen.verpflegung)
  {
    select_fields.push ('verpflegung');
  }
  if (document.suchenundbuchen.abreise)
  {
    select_fields.push ('abreise');
  }

/**
 * Referenz/Instanz von Objekt advancedSearch
 *
 * @var array
 * Übergabe aller relevanten Namen der jeweiligen Select-Felder
 */
  var formRef = new advancedSearch (select_fields);
    
 /** Ende Definition
  ***************************************************************************************/

 /****************************************************************************************
  * Event-Handler mit anonymen Funktionen
  * Initialisierung bei "onchange" auf einzelnen Select-Feldern
  *
  * Aufbau
  * 1. Ueberpruefung ob Feld vorhanden ist
  * 2. Event-Handler
  * 3. Aufruf Hauptmethode des Objekts "advancedSearch" ueber
  *    Referenz "formRef"
  */

  window.onload = function ()
  { 
   /**
    * WICHTIG!!!
    * document.domain für IE 6 setzen, da sonst erstmaliger Zugriff 
    * verweigert wird
    */
    if (navigator.userAgent.match(/MSIE 6/))
    {
      document.domain = document.domain.substring(document.domain.indexOf('.') + 1);
    }
   /**
    * IE verliert bei Reset jegliche Infos über ausgewähltes
    * Datumsfeld, daher in temporaere Variable schreiben und
    * nach reset neu setzen
    * keine Ahnung, warum der das nicht bei anderen macht
    */
    tmp_datum = document.suchenundbuchen.datum.selectedIndex;
    document.suchenundbuchen.reset ();
    document.suchenundbuchen.datum.selectedIndex = tmp_datum;

   /**
    * Für Buchungsprozess
    * damit bei Auswahl eines Request-Zimmers ein Hinweis ausgegeben wird
    * siehe buchen/zielwahl_zimmer.php
    */
    if (document.getElementById('meldung_auf_anfrage')) 
    {
      meldungAufAnfrage();
    }
  }

  function sendForm ()
  {
    sel = document.suchenundbuchen.datum.selectedIndex;
    if (0 == document.suchenundbuchen.datum.options[sel].value)
    {
      document.suchenundbuchen.datum.options[1].selected = 'selected';
    }
    return submit_form_and_wait('suchenundbuchen');
  }

  if (document.suchenundbuchen.land)
  {
    document.suchenundbuchen.land.onchange = function ()
    {
      formRef.startSearch();
    }
  }

  if (document.suchenundbuchen.ziel)
  {
    document.suchenundbuchen.ziel.onchange = function ()
    {
     /**
      * Abfrage, ob Trennlinien selektiert wurden
      */
      if (this.options[this.selectedIndex].value.match (/_0/))
      {
        this.selectedIndex = this.selectedIndex + 1;
      }
      else if (this.options[this.selectedIndex].value.match (/_1/))
      {
        this.selectedIndex = this.selectedIndex - 1;
      }
      formRef.startSearch();
    }
  }

  if (document.suchenundbuchen.datum)
  {
    document.suchenundbuchen.datum.onchange = function ()
    {
      formRef.startSearch();
    }
  }
  
  if (document.suchenundbuchen.dauer)
  {
    document.suchenundbuchen.dauer.onchange = function ()
    {
      formRef.startSearch();
    }
  }
  
  if (document.suchenundbuchen.erwachsene)
  {
    document.suchenundbuchen.erwachsene.onchange = function ()
    {
      formRef.startSearch();
    }
  }

  if (document.suchenundbuchen.verpflegung)
  {
    document.suchenundbuchen.verpflegung.onchange = function ()
    {
      formRef.startSearch();
    }
  }

  if (document.suchenundbuchen.abreise)
  {
    document.suchenundbuchen.abreise.onchange = function ()
    {
      formRef.startSearch();
    }
  }

 /** Ende Event-Handler
  ***************************************************************************************/


