<?php
	
	class DidYouMean {
		
		const MethodLevenshtein = 1;
		const MethodMetaphone = 2;
		const MethodSoundex = 3;
		
		/**
		 * @param array Mgliche Suchworte
		 */
		public $words = array();
		
		/**
		 * @param int Zu verwendende Vergleichsmethode
		 */
		public $method = self::MethodLevenshtein;
		
		/**
		 * @param string
		 */
		public $best;
		
		/**
		 * Vergleicht die Wortliste mit dem bergebenen Wort und gibt das
		 * hnlichste Wort zurck.
		 * 
		 * @return string
		 * @param string
		 */
		public function compare( $compare ) {
			$index = array_search( $compare, $this->words, true );
			if( $index!==false ) {
				// Direkt getroffen
				return( $this->best = $this->words[$index] );
			}
			
			// Levenshtein
			if( $this->method==self::MethodLevenshtein ) {
				return( $this->best = $this->compareLevenshtein( $compare ) );
			}
			
			return( $this->best = $this->compareOther( $compare ) );
		}
		
		private function compareLevenshtein( $compare ) {
			foreach( $this->words as $word ) {
				$value = levenshtein( $word, $compare );
				
				// Direkter Treffer
				if( $value==0 ) {
					return( $word );
				}
				
				// Besseren Treffer gefunden
				if( !isset( $bestValue ) or $value<$bestValue ) {
					$best = $word;
					$bestValue = $value;
				}
			}
			
			return( $best );
		}
		
		private function compareOther( $compare ) {
			if( $this->method==self::MethodMetaphone ) {
				$method = 'metaphone';
			}
			else {
				$method = 'soundex';
			}
			
			$compareValue = $method( $compare );
			
			foreach( $this->words as $word ) {
				$value = $method( $word );
				$value = strlen( $compare ) - similar_text( $value, $compareValue, $value );
				
				// Direkter Treffer
				if( $value==0 ) {
					return( $word );
				}
				
				// Besseren Treffer gefunden
				if( !isset( $bestValue ) or $value<$bestValue ) {
					$best = $word;
					$bestValue = $value;
				}
			}
			
			return( $best );
		}
		
	}
	
	if( isset( $_POST['submit'] ) ) {
		$dym = new DidYouMean();
		$dym->words = array(
	    'ARQUES', 
	    'ATP-Turnier', 
	    'Abchasien', 
	    'Abschaltung', 
	    'Ackermann', 
	    'Agrarsubventionen', 
	    'Airline', 
	    'Anixe', 
	    'Annika', 
	    'Atomausstieg', 
	    'Atomenergie', 
	    'Atommeiler', 
	    'Atompolitik', 
	    'Atomstreit', 
	    'Aufenthaltserlaubnis', 
	    'Ausstand', 
	    'Barrot', 
	    'Barth', 
	    'Baur', 
	    'Beiersdorfer', 
	    'Bertha', 
	    'Bischoff', 
	    'Bitkom', 
	    'Bloomberg', 
	    'Borg', 
	    'Brokkoli', 
	    'Bundesnetzagentur', 
	    'Buschkowsky', 
	    'Cadillac', 
	    'Cannes', 
	    'Carolina', 
	    'Carreras', 
	    'Chevrolet', 
	    'Coleman', 
	    'Computerspiele', 
	    'Credit', 
	    'Crouch', 
	    'DVB-T', 
	    'Debitel', 
	    'Deichmann', 
	    'Dmitri Medwedew', 
	    'Donaueschingen', 
	    'EMI', 
	    'EU-Kommissionsprsident', 
	    'EU-Staaten', 
	    'Einwanderung', 
	    'Einwanderungspolitik', 
	    'Ellwangen', 
	    'Elmshorn', 
	    'Elsass', 
	    'Enkelmann', 
	    'Eppler', 
	    'Erdl', 
	    'EreignisErderwrmung', 
	    'Eurosport', 
	    'Eurowings', 
	    'Flamenco', 
	    'Freddie Mac', 
	    'Freiberg', 
	    'Freizgigkeit', 
	    'Fresenius', 
	    'Frontex', 
	    'Funktionre', 
	    'GEMA', 
	    'GWG', 
	    'Gas Natural', 
	    'Generika', 
	    'Gesamtklassement', 
	    'Gnzburg', 
	    'Gontard', 
	    'Hasan', 
	    'Hauptfeld', 
	    'Heckmann', 
	    'Hedge-Fonds', 
	    'Heiligendamm', 
	    'Heisig', 
	    'Hero', 
	    'Hokkaido', 
	    'Holtzbrinck', 
	    'IPO', 
	    'IT-Fitness', 
	    'Icahn', 
	    'Industrienationen', 
	    'Industrieproduktion', 
	    'Insolvenzantrag', 
	    'Islamabad', 
	    'Kabul', 
	    'Karachi', 
	    'Keith Urban', 
	    'Kerkeling', 
	    'Kernenergie', 
	    'Kernkraft', 
	    'Klckner', 
	    'Klimapolitik', 
	    'Klitschko', 
	    'Komax', 
	    'Lennox', 
	    'Lufthansa', 
	    'Madeleine', 
	    'Mao', 
	    'Martin Jol', 
	    'Mauritius', 
	    'Medwedew', 
	    'Microsoft', 
	    'Morrison', 
	    'NBC', 
	    'NBC Universal', 
	    'Nashville', 
	    'Neu-Isenburg', 
	    'Neuwahlen', 
	    'Nielsen', 
	    'Nintendo', 
	    'Nordex', 
	    'Oliver Shanti', 
	    'Online-Banking', 
	    'Organisation', 
	    'Ort', 
	    'Pakt', 
	    'Pamplona', 
	    'Paulo', 
	    'Personalvorstand', 
	    'Pete', 
	    'Piloten', 
	    'Pilotengewerkschaft', 
	    'Pilotenvereinigung', 
	    'PolitikerBarroso', 
	    'Portsmouth', 
	    'Postbank', 
	    'Rafael Nadal', 
	    'Robert Kubica', 
	    'SPOE', 
	    'SPOE-Chef', 
	    'Salzau', 
	    'Schlagwort', 
	    'Seidenberg', 
	    'Selbstmordattentter', 
	    'Siedlungen', 
	    'Sony', 
	    'Sorin', 
	    'Sport', 
	    'Sportchef', 
	    'Sportler', 
	    'Stadtpark', 
	    'Steg', 
	    'Stiglitz', 
	    'Streik', 
	    'Suedindien', 
	    'TNK-BP', 
	    'TUI', 
	    'Tagessieg', 
	    'Tarifkonflikt', 
	    'Thompson', 
	    'Trainer', 
	    'Unesco', 
	    'Vanessa', 
	    'Verlagsgruppe', 
	    'Versptungen', 
	    'Verwaltungsrat', 
	    'Volksabstimmungen', 
	    'Wedeler', 
	    'Wissenschaftsrat', 
	    'Won', 
	    'Yang', 
	    'Zeitfahren'
	);
		
		$dym->method = $_POST['method'];
		$dym->compare( $_POST['input'] );
	}
	
?>
<form method="post">
	<input type="text" name="input" value="<?php echo ( isset( $_POST['input'] ) ? $_POST['input'] : '' ); ?>" /><br />
	<input type="radio" name="method" value="1" <?php echo ( ( !isset( $_POST['method'] ) or $_POST['method']==1 ) ? 'checked="checked"' : '' ); ?> /> Levenshtein
	<input type="radio" name="method" value="2" <?php echo ( ( isset( $_POST['method'] ) and $_POST['method']==2 ) ? 'checked="checked"' : '' ); ?> /> Metaphone
	<input type="radio" name="method" value="3" <?php echo ( ( isset( $_POST['method'] ) and $_POST['method']==3 ) ? 'checked="checked"' : '' ); ?> /> Soundex<br />
	<input type="submit" name="submit" value="Did you mean?" /><br />
	<?php if( isset( $dym ) ) { echo 'did you mean: '.$dym->best.'?'; } ?>
</form>