<?php
# Von Rene Schmidt (rene@reneschmidt.de) fuer DrWeb.de

// Diese Klasse erzeugt EINE Ziffer
class Digit {

  // Die Zweierpotenzen sind hier schon berechnet notiert, damit sie nicht jedes Mal neu
  // ausgerechnet werden muessen. Wir benoetigen fuer eine 5x3-Matrix, deren Zellen mit
  // Zweierpotenzen maskiert sein sollen 15 Bits, also die Bitmasken 2^0 bis 2^14
  var $bits = array(1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384);

  // Dieses Array enthaelt die Zeilen einer Ziffer, deren Zellen wiederum als Array dargestellt werden
  // Siehe Konstruktor
  var $matrix  = array();

  // Dies sind die fertig berechneten Bitmasken der Ziffern 0 bis 9 in Dezimaldarstellung
  var $bitmasks = array(31599, 18740, 29607, 31143, 18921, 31183, 31695, 18855, 31727, 31215);

  // Konstruktor; nimmt die darzustellende Ziffern entgegen; Matrix wird initialisiert
  // setMatrix() wird mit der korrekten Bitmaske der darzustellenden Ziffer aufgeruefen
  function digit( $dig ) {
    $this->matrix[] = array(0, 0, 0); // 2^0, 2^1, 2^2 ... usw.
    $this->matrix[] = array(0, 0, 0);
    $this->matrix[] = array(0, 0, 0);
    $this->matrix[] = array(0, 0, 0);
    $this->matrix[] = array(0, 0, 0); // ..., ..., 2^14

    ((int)$dig >= 0 && (int)$dig <= 9) && $this->setMatrix( $this->bitmasks[(int)$dig] );
  }

  // Methode erzeugt anhand der Bitmaske die Matrix der Ziffer
  // Vom Konstruktor erhaelt die Methode die Bitmaske der darzustellenden Ziffer
  function setMatrix( $bitmask ) {
    $bitsset = array();

    // Jetzt wird jedes Bit daraufhin geprueft, ob es zur Bitmaske gehoert
    // Wenn ja, wird es im Array $bitset gespeichert
    for ($i=0; $i<count($this->bits); ++$i)
      (($bitmask & $this->bits[$i]) != 0) && $bitsset[] = $this->bits[$i];

    // Nun wird die initialisierte und leere Matrix hergenommen und Zeile fuer Zeile und Zelle fuer Zelle
    // bestueckt. Zellen, die leer sein sollen, bleiben auf 0, aktivierte Zellen erhalten den Wert 1
    // Beispiel aus dem Konstruktor - die Ziffer 1 wuerde als Matrix so aussehen:
    //     $this->matrix[] = array(0, 0, 1); // 2^0, 2^1, 2^2 ... usw.
    //     $this->matrix[] = array(0, 1, 1);
    //     $this->matrix[] = array(0, 0, 1);
    //     $this->matrix[] = array(0, 0, 1);
    //     $this->matrix[] = array(0, 0, 1); // ..., ..., 2^14
    foreach($this->matrix AS $row=>$col)
      foreach($col AS $cellnr => $bit)
        in_array( pow(2,($row*3+$cellnr)), $bitsset) && $this->matrix[$row][$cellnr] = 1;
  }
}

// Diese Klasse kuemmert sich um die korrekte Darstellung mehrerer Ziffern (also einer Zahl)
class Number {

  var $num = 0; // Zahl, die dargestellt werden soll
  var $digits = array(); // Enthaelt spaeter fuer jede Stelle ein Digit-Objekt

  // Konstruktor; nimmt direkt die darzustellende Zahl entgegen.
  function number( $num ) {
    $this->num = (int)$num; // Zur Sicherheit in ganze Zahl umwandeln

    $r = "{$this->num}"; // In Zeichenkette konvertieren

    // Jetzt fuer jede Stelle der Zahl ein Digit-Objekt erzeugen
    for( $i=0; $i<strlen($r); $i++ )
      $this->digits[] = new Digit((int)$r[$i]);
  }

  // Liefert einfach die Zahl, die dargestellt wird.
  function getNum() { return $this->num; }

  // Gibt die Zeilen aller Ziffern nacheinander aus; also erst alle ersten, dann alle zweiten Zeilen usw.
  function printNumber() {
    for($row=0; $row<count($this->digits[0]->matrix); $row++) {
      foreach( $this->digits AS $digit ) {
        foreach($digit->matrix[$row] AS $cell)
          if($cell === 1) // 1 bedeutet, die Zelle soll aktiv sein (=schwarz)
            print("<span class=\"s\">&nbsp;&nbsp;</span>");
          else
            print("<span class=\"w\">&nbsp;&nbsp;</span>");
        print("<span class=\"w\">&nbsp;</span>"); // Leerraum zwischen den Ziffern
      }
      print("<br>"); // Naechste Zeile
    }
  }
}

?>

<html>
<head>
<style>
    .s { color: black; background-color: black; }
    .w { color: white; background-color: white; }
</style>
</head>
<body>
<h2>Beispiel</h2>
<div >
<?php
$n = new Number( rand(1000,9999) );
$n->printNumber();
printf( "<h2>Dargestellt wird die Zahl %d</h2>", $n->getNum() );
?>
</div>

</body>
</html>