-- 
-- Tabellenstruktur für Tabelle `tbl_buchung_anpassung`
-- 

CREATE TABLE `tbl_buchung_anpassung` (
  `aenderung_id` int(11) NOT NULL auto_increment,
  `konto_id_fk` int(11) NOT NULL,
  `betrag_neu` double NOT NULL,
  `monat` int(11) NOT NULL,
  `jahr` int(11) NOT NULL,
  PRIMARY KEY  (`aenderung_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- 
-- Daten für Tabelle `tbl_buchung_anpassung`
-- 

INSERT INTO `tbl_buchung_anpassung` VALUES (1, 4001, 1000, 1, 2009);
INSERT INTO `tbl_buchung_anpassung` VALUES (2, 4001, 1000, 2, 2009);
INSERT INTO `tbl_buchung_anpassung` VALUES (3, 4001, 1000, 3, 2009);

-- --------------------------------------------------------

-- 
-- Tabellenstruktur für Tabelle `tbl_buchung_netto`
-- 

CREATE TABLE `tbl_buchung_netto` (
  `buchung_id` int(11) NOT NULL auto_increment,
  `buchung_nr` int(11) NOT NULL,
  `beleg_nr` varchar(255) default NULL,
  `konto_id_fk` int(11) NOT NULL,
  `zahlung_datum` date NOT NULL,
  `netto_betrag` double NOT NULL,
  `brutto_betrag` double NOT NULL,
  `zahlung_betrag` double NOT NULL,
  PRIMARY KEY  (`buchung_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

-- 
-- Daten für Tabelle `tbl_buchung_netto`
-- 

INSERT INTO `tbl_buchung_netto` VALUES (1, 1, '01', 1, '2009-01-02', 100, 119, 100);
INSERT INTO `tbl_buchung_netto` VALUES (2, 2, '01', 26, '2009-01-01', 100, 107, -100);
INSERT INTO `tbl_buchung_netto` VALUES (3, 3, '1', 6, '2009-02-01', 100, 119, 100);
INSERT INTO `tbl_buchung_netto` VALUES (4, 4, '1', 4001, '2009-01-01', 1000, 1000, -1000);
INSERT INTO `tbl_buchung_netto` VALUES (5, 5, '01', 1, '2009-03-15', 1260.5, 1500, 1260.5);
INSERT INTO `tbl_buchung_netto` VALUES (6, 6, '102', 21, '2009-02-12', 453.78, 540, -453.78);
INSERT INTO `tbl_buchung_netto` VALUES (7, 7, '103', 26, '2009-02-13', 71.43, 85, -71.43);
INSERT INTO `tbl_buchung_netto` VALUES (8, 8, '104', 50, '2009-02-13', 750, 750, -750);
INSERT INTO `tbl_buchung_netto` VALUES (9, 9, '106', 17, '2009-02-13', 1071.43, 1200, -1071.43);
INSERT INTO `tbl_buchung_netto` VALUES (10, 10, '105', 3, '2009-02-02', 934.58, 1000, 934.58);
INSERT INTO `tbl_buchung_netto` VALUES (11, 11, '4711', 26, '2009-01-10', 93.46, 100, -93.46);

-- --------------------------------------------------------

-- 
-- Tabellenstruktur für Tabelle `tbl_buchung_steuer`
-- 

CREATE TABLE `tbl_buchung_steuer` (
  `buchung_steuer_id` int(11) NOT NULL auto_increment,
  `buchung_id_fk` int(11) NOT NULL,
  `buchung_nr_fk` int(11) NOT NULL,
  `buchung_datum` date NOT NULL,
  `konto_steuer_typ_id_fk` int(11) NOT NULL,
  `steuer_satz` int(11) NOT NULL,
  `steuer_betrag` double NOT NULL,
  `zahlung_steuerbetrag` double default NULL,
  PRIMARY KEY  (`buchung_steuer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

-- 
-- Daten für Tabelle `tbl_buchung_steuer`
-- 

INSERT INTO `tbl_buchung_steuer` VALUES (1, 1, 1, '2009-01-02', 3806, 19, 19, 19);
INSERT INTO `tbl_buchung_steuer` VALUES (2, 2, 2, '2009-01-01', 1401, 7, 7, -7);
INSERT INTO `tbl_buchung_steuer` VALUES (3, 3, 3, '2009-02-01', 3806, 19, 19, 19);
INSERT INTO `tbl_buchung_steuer` VALUES (4, 4, 4, '2009-01-01', 0, 0, 0, 0);
INSERT INTO `tbl_buchung_steuer` VALUES (5, 5, 5, '2009-03-15', 3806, 19, 239.5, 239.5);
INSERT INTO `tbl_buchung_steuer` VALUES (6, 6, 6, '2009-02-12', 1406, 19, 86.22, -86.22);
INSERT INTO `tbl_buchung_steuer` VALUES (7, 7, 7, '2009-02-13', 1406, 19, 13.57, -13.57);
INSERT INTO `tbl_buchung_steuer` VALUES (8, 8, 8, '2009-02-13', 0, 0, 0, 0);
INSERT INTO `tbl_buchung_steuer` VALUES (9, 9, 9, '2009-02-13', 0, 12, 128.57, -128.57);
INSERT INTO `tbl_buchung_steuer` VALUES (10, 10, 10, '2009-02-02', 3801, 7, 65.42, 65.42);
INSERT INTO `tbl_buchung_steuer` VALUES (11, 11, 11, '2009-01-10', 1401, 7, 6.54, -6.54);

-- --------------------------------------------------------

-- 
-- Tabellenstruktur für Tabelle `tbl_konten`
-- 

CREATE TABLE `tbl_konten` (
  `buchungskonten_id` int(11) NOT NULL auto_increment,
  `konto_id` int(11) NOT NULL,
  `konto_name` varchar(255) NOT NULL,
  `konto_typ` enum('ertrag','aufwand') NOT NULL,
  PRIMARY KEY  (`buchungskonten_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=78 ;

-- 
-- Daten für Tabelle `tbl_konten`
-- 

INSERT INTO `tbl_konten` VALUES (1, 1, 'Ertrag 1', 'ertrag');
INSERT INTO `tbl_konten` VALUES (2, 3, 'Ertrag 2', 'ertrag');
INSERT INTO `tbl_konten` VALUES (5, 6, 'Ertrag 3', 'ertrag');
INSERT INTO `tbl_konten` VALUES (16, 17, 'Aufwand 1', 'aufwand');
INSERT INTO `tbl_konten` VALUES (39, 21, 'Aufwand 2', 'aufwand');
INSERT INTO `tbl_konten` VALUES (44, 26, 'Aufwand 3', 'aufwand');
INSERT INTO `tbl_konten` VALUES (68, 50, 'Aufwand 4', 'aufwand');
INSERT INTO `tbl_konten` VALUES (72, 1406, 'Aufwand Vorsteuer 1', 'aufwand');
INSERT INTO `tbl_konten` VALUES (73, 1401, 'Aufwand  Vorsteuer 2', 'aufwand');
INSERT INTO `tbl_konten` VALUES (74, 3806, 'Ertrag USteuer 1', 'ertrag');
INSERT INTO `tbl_konten` VALUES (75, 3801, 'Ertrag USteuer 2', 'ertrag');
INSERT INTO `tbl_konten` VALUES (77, 4001, 'Aufwand Tilgung 1', 'aufwand');
