<?php

// Klasse einbinden
include( 'validator.class.php' );

// Validator Objekt erzeugen
$formular = new Validator();

/* --------------------------- */
/* --- Anwendungsbeispiele --- */
/* --------------------------- */

/**
 * Zahlen - nur Ziffern werden als gültig erkannt
 *
 * Parameter: Wert, Feld-Bezeichnung
 */
$zahl = 123456789;
$formular->pruefeZahl( $zahl, 'Zahl' );

/**
 * Postleitzahl - nur 5-stellige Zahlen werden als gültig erkannt
 * 12345 = true
 * 93746 = true
 * 45x98 = false
 * 123.4 = false
 *
 * Parameter: Wert, Feld-Bezeichnung
 */
$plz = 12345;
$formular->pruefePLZ( $plz, 'PLZ' );

/**
 * Datum - nur ein gültiges Datum im deutschen Format wird als gültig erkannt
 * 15.7.2004  = true ( Trennzeichen = . )
 * 15-7-2004  = true ( Trennzeichen = - )
 * 15/7/2004  = true ( Trennzeichen = / )
 * 29.02.2008 = true
 * 29.02.2007 = false
 * 31.11.2008 = false
 * 24 12 2008 = false
 *
 * Parameter: Wert, Feld-Bezeichnung, Trennzeichen
 */
$datum = '24.12.2008';
$formular->pruefeDatum( $datum, 'Datum', '.' );

/**
 * Telefonnummer - Zahlen mit Telefonnummer-Struktur werden als gültig erkannt
 * 0123 45678    = true
 * +49 123 45678 = true
 * (0) 123 45678 = true
 * 0123 45 678   = true
 * 0123 / 45678  = true
 *
 * Parameter: Wert, Feld-Bezeichnung
 */
$telefonnummer = '0123 / 45678';
$formular->pruefeTelefon( $telefonnummer, 'Telefonnummer' );

/**
 * Geldbetrag - Nur Geldbetrag-Strukturen werden als gültig erkannt
 * 399          = true
 * 399,49       = true
 * 1.399,00     = true
 * 1.000.000    = true
 * 1.234.567,89 = true
 * 399,499      = false
 * 23.45,99     = false
 * 0399         = false
 *
 * Parameter: Wert, Feld-Bezeichnung
 */
$geldbetrag = '1.234.567,89';
$formular->pruefeGeldbetrag( $geldbetrag, 'Geldbetrag' );

/**
 * Wort - nur einzelne Wörter bestehend aus Buchstaben werden als gültig erkannt
 * Baumhaus     = true
 * Karl-Heinz   = false
 * Route66      = false
 * Schreibtisch = false (FALSE wenn Maximallänge z.B. 10 Zeichen beträgt)
 * CSS          = false (FALSE wenn Mindestlänge z.B. 5 Zeichen beträgt)
 *
 * Parameter: Wert, Feld-Bezeichnung, Mindestlänge, Maximallänge
 * Mindestlänge und Maximallänge haben als Default 999 und wird daher ignoriert
 */
$wort = 'Audi';
$formular->pruefeWort( $wort, 'Automarke', 3, 20 );

/**
 * Name - nur Wörter mit Namen-Struktur werden als gültig erkannt
 * Max Mustermann       = true
 * Prof. Max Mustermann = true
 * Mister O'Leary       = true
 * Karl-Heinz Schmitt   = true
 * Fritz Fischer 3.     = false
 * Klaus Kleister       = false (FALSE wenn Maximallänge z.B. 10 Zeichen beträgt)
 * Kalle                = false (FALSE wenn Mindestlänge z.B. 7 Zeichen beträgt)
 *
 * Parameter: Wert, Feld-Bezeichnung, Mindestlänge, Maximallänge
 * Mindestlänge und Maximallänge haben als Default 999 und wird daher ignoriert
 */
$name = 'Prof. Dr. Max Mustermann';
$formular->pruefeName( $name, 'Benutzername', 5, 50 );

/**
 * Text - normaler Text wird als gültig erkannt
 *
 * Parameter: Wert, Feld-Bezeichnung, Mindestlänge, Maximallänge
 * Mindestlänge und Maximallänge haben als Default 999 und wird daher ignoriert
 */
$text = 'Hier steht belangloser Text der eeewig lang sein kann.';
$formular->pruefeText( $text, 'Nachricht', 15, 1500 );

/**
 * Email-Adresse - Nur Email-Adressen werden als gültig erkannt
 *
 * Parameter: Wert, Feld-Bezeichnung
 */
$email = 'jemand@irgendwo.de';
$formular->pruefeEmail( $email, 'Email' );

/**
 * Web-Adresse - Nur Web-Adressen werden als gültig erkannt
 * http://www.domain.de    = true
 * www.domain.de           = true
 * https://www.domain.de   = true
 * http://domain.de        = true
 * www.domain.de/seite.htm = true
 *
 * Parameter: Wert, Feld-Bezeichnung
 */
$url = 'http://www.eine-domain.de';
$formular->pruefeURL( $url, 'URL' );



/**
 * Abfrage ob Fehler aufgetreten sind und diese ggfs. ausgeben.
 * getError() liefert ein Array zurück dessen Schlüssel den Feldnamen
 * entspricht, die man bei den Methoden-Aufrufen übergeben hat.
 * Der Wert enthält die Fehlermeldung, die in der Klasse gesetzt wurden.
 * Natürlich kann man auch statt $fehler eigene Meldungen ausgeben.
 */
if (count( $formular->getError() ) > 0)
{
	foreach ($formular->getError() as $feld => $fehler)
	{
		echo $feld. ': ' .$fehler. "<br />\n";
	}
}


?>