<?php
class mail_class
{
  function header($mail_modus, $attachments)
  {
    $time = time();
    $header = "Message-ID: <$time>\r\n";
    $header .= "From: $options[name_mail] <$options[email]>\r\n";
    $header .= "Return-Path: <$options[email]>\r\n";
    
    if($attachments)
    {
      $header .= "MIME-Version: 1.0\r\n";
      $header .= "Content-Type: multipart/mixed;\r\n boundary=\"Message-Boundary\"\r\n";
    }
    else
    {
      if($mail_modus == "html")
      {
        $header .= "MIME-version: 1.0\r\n";
        $header .= "Content-Type: multipart/alternative;\r\n boundary=\"Message-Boundary\"\r\n";
      }
      else
      {
        $header .= "Content-Type: text/plain\r\n";
        $header .= "Content-Transfer-Encoding: 7Bit\r\n";
      }
    }

    $header .= "X-Priority: 3\r\n";
    $header .= "X-MSMail-Priority: Normal\r\n";
    $header .= "X-Mailer: 1st News PHP-Script\r\n";
    $header .= "X-MimeOLE: Produced By 1st News";

    return $header;
  }

  function body_begin($mail_modus, $attachments)
  {
    $body = "";

    if($attachments && $mail_modus == "html")
    {
      $body .= "--Message-Boundary\r\n";
      $body .= "Content-Type: multipart/alternative;\r\n boundary=\"Message-Boundary\"\r\n\r\n";

      $body .= "--Message-Boundary\r\n";
      $body .= "Content-Type: text/plain;\r\n charset=\"iso-8859-1\"\r\n";
      $body .= "Content-Transfer-Encoding: quoted-printable\r\n\r\n";
      $body .= "Ihr Mailclient untersttzt die Anzeige von HTML-Mails nicht...\r\n";
      
      $body .= "--Message-Boundary\r\n";
      $body.= "Content-Type: text/html;\r\n charset=\"iso-8859-1\"\r\n";
      $body.= "Content-Transfer-Encoding: 7Bit\r\n\r\n";
    }
    
    if($attachments && $mail_modus != "html")
    {
      $body .= "--Message-Boundary\r\n";
      $body.= "Content-Type: text/plain;\r\n charset=\"iso-8859-1\"\r\n";
      $body.= "Content-Transfer-Encoding: 7Bit\r\n\r\n";
    }
    
    if(!$attachments && $mail_modus == "html")
    {
      $body .= "--Message-Boundary\r\n";
      $body .= "Content-Type: text/plain;\r\n charset=\"iso-8859-1\"\r\n";
      $body .= "Content-Transfer-Encoding: quoted-printable\r\n\r\n";
      $body .= "Ihr Mailclient untersttzt die Anzeige von HTML-Mails nicht...\r\n";

      $body .= "--Message-Boundary\r\n";
      $body.= "Content-Type: text/html;\r\n charset=\"iso-8859-1\"\r\n";
      $body.= "Content-Transfer-Encoding: 7Bit\r\n\r\n";
    }

    return $body;
  }

  function body_end($attachments, $mail_modus)
  {
    if($mail_modus == "html") $body .= "\r\n\r\n--Message-Boundary--";

    if($attachments)
    {
      $attachment = split(";", $attachments);
      $count = count($attachment) - 1;
      $i = 0;
      
      while($i < $count)
      {
        $file_name = $attachment[$i];
        $file_size = filesize("attachments/temp/" . $file_name);

        $fp = fopen("attachments/temp/" . $file_name, "r");
        $contents = fread($fp, $file_size);
        $encoded_file = chunk_split(base64_encode($contents));
        fclose($fp);

        $arr_filename = split("\.", $file_name);
        $arr_max = count($arr_filename) - 1;
        $file_extension = trim($arr_filename[$arr_max]);
        
        $file_type = "application/octet-stream;";
        if($file_extension == "ps") $file_type = "application/postscript";
        if($file_extension == "pdf") $file_type = "application/pdf";
        if($file_extension == "doc") $file_type = "application/msword";
        if($file_extension == "wav") $file_type = "audio/basic";
        if($file_extension == "jpeg" || $file_extension == "jpg") $file_type = "image/jpeg";
        if($file_extension == "gif") $file_type = "image/gif";
        if($file_extension == "htm" || $file_extension == "html") $file_type = "text/html";
        if($file_extension == "txt") $file_type = "text/plain";
        if($file_extension == "mpg" || $file_extension == "mpeg") $file_type = "video/mpeg";
        if($file_extension == "mp3") $file_type = "audio/mpeg";
        
        $body .= "--Message-Boundary\r\n";
        $body .= "Content-Type: $file_type\r\n name=\"$file_name\"\r\n";
        $body .= "Content-Transfer-Encoding: base64\r\n";
        $body .= "Content-Disposition: attachment;\r\n filename=\"$file_name\"\r\n";
        $body .= "Content-ID: $file_name\r\n\r\n";
        $body .= "$encoded_file";

        @unlink("attachments/temp/" . $file_name);
        $i++;
      }
      $body .= "\r\n--Message-Boundary--\r\n";
    }
    
    return $body;
  }

  function message($mail_modus, $attachments, $textarea, $msg_delete, $show_msg_delete = "1")
  {
    if($show_msg_delete = "1") return $this->body_begin($mail_modus, $attachments) . str_replace("[attachment]/", "cid:", $textarea) . $this->removal_direction($mail_modus, $msg_delete) . $this->body_end($attachments, $mail_modus);
    else return $this->body_begin($mail_modus, $attachments) . str_replace("[attachment]/", "cid:", $textarea) . $this->body_end($attachments, $mail_modus);
  }

  function removal_direction($mail_modus, $msg_delete)
  {
    if($mail_modus == "html") $direction = "<br>\r\n<br>" . str_replace("{firstnews}", "<a href=\"". $options["url"] . "\" target=\"_blank\">" . $options["url"] . "</a>", nl2br($options["$msg_delete"]));
    else $direction = "\r\n\r\n" . str_replace("{firstnews}", $options["url"], $options["$msg_delete"]);

    return $direction;
  }

  function simple_textmail()
  {
    global $options;

    $header = "From: $options[name_mail] <$options[email]>\r\n";
    $header .= "Return-Path: <$options[email]>\r\n";
    $header .= "MIME-Version: 1.0\r\n";
    $header .= "Content-Type: text/plain; charset=\"iso-8859-1\"\r\n";
    $header .= "Content-Transfer-Encoding: 7bit";

    return $header;
  }
  
  function test($attachments, $mail_modus)
  {
    if($mail_modus == "html") $body .= "\r\n\r\n--Message-Boundary--";

    if($attachments)
    {
      $attachment = split(";", $attachments);
      $count = count($attachment) - 1;
      $i = 0;
      
      while($i < $count)
      {
        $file_name = $attachment[$i];
        
        $arr_filename = split("\.", $file_name);
        $arr_max = count($arr_filename) - 1;
        
        echo $arr_max;
        
        $file_extension = trim($arr_filename[$arr_max]);

        $file_type = "application/octet-stream;";
        if($file_extension == "ps") $file_type = "application/postscript";
        if($file_extension == "pdf") $file_type = "application/pdf";
        if($file_extension == "doc") $file_type = "application/msword";
        if($file_extension == "wav") $file_type = "audio/basic";
        if($file_extension == "jpeg" || $file_extension == "jpg") $file_type = "image/jpeg";
        if($file_extension == "gif") $file_type = "image/gif";
        if($file_extension == "htm" || $file_extension == "html") $file_type = "text/html";
        if($file_extension == "txt") $file_type = "text/plain";
        if($file_extension == "mpg" || $file_extension == "mpeg") $file_type = "video/mpeg";
        if($file_extension == "mp3") $file_type = "audio/mpeg";

        $body .= "\r\n\r\n--Message-Boundary\r\n";
        $body .= "Content-Type: $file_type\r\n name=\"$file_name\"\r\n";
        $body .= "Content-Transfer-Encoding: base64\r\n";
        $body .= "Content-Disposition: attachment;\r\n filename=\"$file_name\"\r\n";
        $body .= "Content-ID: $file_name\r\n\r\n";
        $body .= "$encoded_file";

        $i++;
      }
      $body .= "\r\n--Message-Boundary--";
    }

    return $body;
  }
}
/*
$mail = new mail_class;
echo str_replace("\r\n", "<br>", $mail->test("Tacho.jpg;", "Text"));*/

?>
