<?php
class MySQLStatement{


  private $verbindung; 

  private $sql;        

  private $ergebnis = false;   


 
  public function __construct($verbindung, $sql){

    $this->sql = $sql;
    $this->verbindung = $verbindung;

  }


   
  public function ausfuehren(){

    $args = func_get_args();
    $this->SQLersetzen($args); 

    $this->ergebnis = $this->verbindung->query($this->sql);

    if(!$this->ergebnis){
      if(ERRORS)
        die('<p><strong>Datenbank-Fehler</strong>:<br />' . FEHLERMELDEN . '</p>
             <p><strong>Fehler in mysqli_query:</strong><br />' . $this->verbindung->error . '</p>
             <p><strong>Kompletter SQL-String:</strong><br />' . $this->sql);
      die(UNBEKANNTERFEHLER);
    }

  }


  public function multiAusfuehren(){

    
    $unikum = md5(time());

    $args = func_get_args();

    
    foreach($args as $schluessel=>$wert){
      $args[$schluessel] = str_replace(';', $unikum, $wert);
    }

    
    $this->SQLersetzen($args);

   
    $arr = preg_split('!;!', $this->sql);

    foreach($arr as $wert){
      
      $wert = str_replace($unikum, ';', $wert);
      $this->ergebnis = $this->verbindung->query($wert);
      if(!$this->ergebnis){
        break;
      }
    }

    if(!$this->ergebnis){
      if(ERRORS)
        die('<p><strong>Datenbank-Fehler</strong>:<br />' . FEHLERMELDEN . '</p>
             <p><strong>Fehler in mySQL_Statement::multiAusfuehren():</strong><br />' .
                $this->verbindung->error . '</p>
             <p><strong>Kompletter SQL-String:</strong><br />' . $this->sql);
      die(UNBEKANNTERFEHLER);
    }

  }


 
  private function SQLersetzen($args){

    foreach($args as $schluessel=>$wert){

      $regexp = "!:$schluessel\b!";

      $this->sql = preg_replace($regexp, "'" . $this->verbindung->real_escape_string($wert) . "'",
                                $this->sql);
    }

  }


 
  public function num_rows(){

    if(!$this->ergebnis){
      if(ERRORS)
        die($this->ungueltigeRessource('num_rows()'));
      die(UNBEKANNTERFEHLER);
    }

    if($this->ergebnis === true){
      if(ERRORS) 
        die($this->ressourcenfehler());
      die(UNBEKANNTERFEHLER);
    }
    return $this->ergebnis->num_rows;

  }


  
  public function insert_id(){

    if(!$this->ergebnis){
      if(ERRORS) 
        die($this->ungueltigeRessource('insert_id()'));
      die(UNBEKANNTERFEHLER);
    }

    if($this->ergebnis === true){
      return $this->verbindung->insert_id;
    }
    if(ERRORS)
      die('<p><em>MySQLStatement::insertID()</em> gescheitert.');
    die(UNBEKANNTERFEHLER);

  }


 
  public function fetch_row(){

    if(!$this->ergebnis){
      if(ERRORS)
        die($this->ungueltigeRessource('fetch_row()'));	
      die(UNBEKANNTERFEHLER);
    }

    if($this->ergebnis === true){
      if(ERRORS) 
        die($this->ressourcenfehler());
      die(UNBEKANNTERFEHLER);
    }

    return $this->ergebnis->fetch_row();

  }


  
  public function fetch_assoc(){

    if(!$this->ergebnis){
      if(ERRORS)
        die($this->ungueltigeRessource('fetch_assoc()'));	
      die(UNBEKANNTERFEHLER);
    }

    if($this->ergebnis === true){
      if(ERRORS)
        die($this->ressourcenfehler());
      die(UNBEKANNTERFEHLER);
    }

   
    return $this->ergebnis->fetch_assoc(); 

  }


  
  public function fetch_array(){

    if(!$this->ergebnis){
      if(ERRORS)
        die($this->ungueltigeRessource('fetch_array()'));	
      die(UNBEKANNTERFEHLER);
    }

    if($this->ergebnis === true){ 
      if(ERRORS)
        die($this->ressourcenfehler());
      die(UNBEKANNTERFEHLER);
    }

    
    return $this->ergebnis->fetch_array; 

  }


  public function fetch_object(){

    if(!$this->ergebnis){
      if(ERRORS)
        die($this->ungueltigeRessource('fetch_object()'));	
      die(UNBEKANNTERFEHLER);
    }

    if($this->ergebnis === true){ 
      if(ERRORS)
        die($this->ressourcenfehler());
      die(UNBEKANNTERFEHLER);
    }

    
    return $this->ergebnis->fetch_object(); 

  }


 
  public function free_result(){

    if(!$this->ergebnis || $this->ergebnis === true){
      if(ERRORS)
        die($this->ungueltigeRessource('free_result()'));
      die(UNBEKANNTERFEHLER);
    }

    
    $this->ergebnis->free();

  }


  
  private function ressourcenfehler(){ 
    return '<p><strong>Datenbank-Fehler</strong>:<br />' . FEHLERMELDEN . '</p>' .
           '<p><strong>Fehlermeldung</strong>:<br />Der SQL-String lieferte keine Ressource ' .
           '(ungueltige Ressourcen liefern z.B. INSERT-, UPDATE- und DELETE-Abfragen).</p>' .
           '<p><strong>Kompletter SQL-String:</strong><br />' . $this->sql;
  }


  
  private function ungueltigeRessource($funktion){
    return '<p><strong>Datenbank-Fehler</strong>:<br />' . FEHLERMELDEN . '</p>' .
           '<p><strong>Fehlermeldung:</strong><br /><em>MySQLStatement::' . $funktion .
           '</em> muss mit gueltiger Ressource aufgerufen werden ' .
           '(Zuerst MySQLStatement::ausfuehren() aufrufen).</p>' .
           '<p><strong>Kompletter SQL-String:</strong><br />' . $this->sql;
  }


}
?>