<?php
    /* here we must specify the version of XML : i.e: 1.0 */
    $xml = new DomDocument('1.0');
    $xml->load('xml/library.xml');

    /* first to create a list of categories */
    $categories = array();
    $XMLCategories = $xml->getElementsByTagName('categories')->item(0);

    foreach($XMLCategories->getElementsByTagName('category') as $categoryNode) {
        /* notice how we get attributes */
        $cid = $categoryNode->getAttribute('cid');
        $categories[$cid] = $categoryNode->firstChild->nodeValue;
    }
?>
<html>
    <head>
        <title>XML Library</title>
    </head>
    <body>
        <?php foreach($xml->getElementsBytagName('book') as $book):
            /* find the title */
            $title = $book->getElementsByTagName('title')->item(0)->firstChild->nodeValue;

            /* find the author - for simplicity we assume there is only one */
            $author = $book->getElementsByTagName('author')->item(0)->firstChild->nodeValue;

            /* list categories */    
            $bookCategories = $book->getElementsByTagName('category');

            $catList = '';
            foreach($bookCategories as $category) {
                $catList .= $categories[$category->firstChild->nodeValue] . ', ';
            }
            
            $catList = substr($catList, 0, -2); ?>
            
        <div>
            <h2><?php echo($title) ?></h2>
            <p><b>Author:</b>: <?php echo($author) ?></p>
            <p><b>Categories: </b>: <?php echo($catList) ?></p>
        </div>    
        <?php endforeach; ?>
</html> 