<?php
/*****************************************************************
**         Zeltru-Design ReferenceList                          **
**                                                              **
**     (c) Copyright 2004-2005 by Zeltru-Design Zeljko Trulec   **
**         http://www.zeltru-design.de                          **
**         created @ August 2004                                **
**         last change @ August 2005                            **
**                                                              **
**         @ Released under GNU/GPL License:                    **
**         http://www.gnu.org/copyleft/gpl.html                 **
*****************************************************************/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class referenceList extends mosDBTable {
	/** @var int Primary key */
  var $id;
  /** @var string */
  var $name;
  /** @var string */
  var $hplink;
  /** @var string */
  var $description;
  /** @var string */
  var $systems;
  /** @var int */
	var $published=null;
	/** @var int */
	var $checked_out=null;
	/** @var datetime */
	var $checked_out_time=null;
	/** @var int */
	var $ordering=null;
  
  function referencelist( &$db ) {
    $this->mosDBTable( '#__referencelist', 'id', $db );
	}

  function search( $text, $state='' ) {
		$text = trim( $text );
		if ($text == '') {
			return array();
		}
		
		$query_raw = "SELECT id, '0' AS created, name as title,"
		. "\n	' ' AS href, description AS text, '1' AS browsernav, 'ReferenceList' AS section"
		. "\nFROM #__referencelist WHERE (name LIKE '%$text%'"
		. "\n OR description LIKE '%$text%')"
		. "\n ORDER BY ordering";
    $this->_db->setQuery( $query_raw );
    
    $ret = $this->_db->loadObjectList();
    
    if(is_array($ret)) {
      foreach( $ret as $p_key => $p_val ) {
        $ret[$p_key]->href = 'index.php?option=com_referencelist#' . $ret[$p_key]->id;
      }
    }
    #echo "<pre>"; print_r($ret); echo "</pre>";
    
		return $ret;
	}

  function get_image_count($ref_id=null) {
    global $database;
    if (!$ref_id) return false;
    $query_raw = "SELECT count(*) as anz"
		. "\nFROM #__referencelist_img WHERE ref_id=" . (int)$ref_id;
    $database->setQuery( $query_raw );
    $arr = $database->loadAssocList();
    return $arr[0]["anz"];
  }

  function get_ref_name($ref_id=null) {
    global $database;
    if (!$ref_id) return false;
    $query_raw = "SELECT name"
		. "\nFROM #__referencelist WHERE id=" . (int)$ref_id;
    $database->setQuery( $query_raw );
    $arr = $database->loadAssocList();
    return $arr[0]["name"];
  }
}

class referenceImages extends mosDBTable {
  /** @var int Primary key */
  var $id;
  /** @var int */
  var $ref_id;
  /** @var string */
  var $ref_thumb_name;
  /** @var string */
  var $ref_img_name;
  /** @var int */
	var $published=null;
  /** @var int */
	var $ordering=null;

  function referenceImages( &$db ) {
    $this->mosDBTable( '#__referencelist_img', 'id', $db );
	}
}

class referenceConfig extends mosDBTable {
  /** @var string */
  var $cfg_name;
  /** @var string */
  var $cfg_value;
  
  function referenceConfig( &$db ) {
    $this->mosDBTable( '#__referencelist_cfg', 'cfg_name', $db );
	}

  function loadAll() {
    $this->cfg = array();
    $this->_db->setQuery( "SELECT cfg_name, cfg_value FROM $this->_tbl" );
    $arr = $this->_db->loadAssocList();
    foreach($arr as $key => $val) {
      $this->cfg[$val["cfg_name"]] = $val["cfg_value"];
    }
  }

  function loadAdminConf() {
    $this->_db->setQuery( "SELECT * FROM $this->_tbl ORDER BY ordering" );
    return $this->_db->loadObjectList();
  }
}
?>