<?php
/*****************************************************************
**         Zeltru-Design ReferenceList                          **
**                                                              **
**     (c) Copyright 2004-2005 by Zeltru-Design Zeljko Trulec   **
**         http://www.zeltru-design.de                          **
**         created @ August 2004                                **
**         last change @ August 2005                            **
**                                                              **
**         @ Released under GNU/GPL License:                    **
**         http://www.gnu.org/copyleft/gpl.html                 **
*****************************************************************/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
    | $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_referencelist' ))) {
  mosRedirect( 'index2.php', _NOT_AUTH );
}

/* Files to include */
$refL_path_comp = dirname(__FILE__);
$refL_path_comp = str_replace('\\','/', realpath($refL_path_comp));
$refL_path = str_replace($_SERVER['DOCUMENT_ROOT'],'',$refL_path_comp);
$refl_version = array("2.22", "29.08.2005");

/* own language files*/
if ($mosConfig_alang && file_exists($refL_path_comp . "/language/" . $mosConfig_alang . ".php")) $inc_language = $refL_path_comp . "/language/" . $mosConfig_alang . ".php";
elseif(file_exists($refL_path_comp . "/language/" . $mosConfig_lang . ".php")) {
  $inc_language = $refL_path_comp . "/language/" . $mosConfig_lang . ".php";
}
elseif(file_exists($refL_path_comp . "/language/english.php")) {
  $inc_language = $refL_path_comp . "/language/english.php";
}
else die("Missing Languagefile in " . $refL_path_comp . "/language/");
require_once($inc_language);

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );
$refL_front_path = dirname($mainframe->getPath( 'class' ));

if ( !function_exists("mosGetImg") && !function_exists("mosGetSpacer") ) {
  require_once( $refL_front_path . "/referencelist.function.php");
}

$task = trim( mosGetParam( $_REQUEST, 'task', "" ) );
$pid = mosGetParam( $_REQUEST, 'pid', array(0) );
$ref_id = mosGetParam( $_REQUEST, 'ref_id', 0 );
if (!is_array( $pid )) {
  $pid = array(0);
}

switch ($task) {
  /* References */
  case "new":
    editReference( '0', $option);
    break;

  case "edit":
    editReference( $pid[0], $option );
    break;

  case "save":
    saveReference( $option );
    break;

  case "cancel":
    cancelReference( $option );
    break;

  case "remove":
    removeReference( $pid, $option );
    break;

  case "publish":
    changeReference( $pid, 1, $option );
    break;

  case "unpublish":
    changeReference( $pid, 0, $option );
    break;

  case "orderup":
    orderReference( $pid[0], -1, $option );
    break;

  case "orderdown":
    orderReference( $pid[0], 1, $option );
    break;

  /* Images */
  case "listImages":
    listReferenceImages($pid[0], $option );
    break;

  case "add_img":
    addReferenceImages($ref_id, $option );
    break;

  case "remove_image":
    removeReferenceImages( $pid, $ref_id, $option );
    break;

  case "publish_images":
    changeReferenceImages( $pid, $ref_id, 1, $option );
    break;

  case "unpublish_images":
    changeReferenceImages( $pid, $ref_id, 0, $option );
    break;

  case "orderup_images":
    orderReferenceImages( $pid[0], $ref_id, -1, $option );
    break;

  case "orderdown_images":
    orderReferenceImages( $pid[0], $ref_id, 1, $option );
    break;

  /* About */
  case "about":
    showAbout( $option );
    break;

  /* Config */
  case "config":
    showConfig( $option );
    break;

  case "save_config":
    saveConfig( $option );
    break;

  /* Upload / Delete */
  case "uploadimage":
  case "deleteimage":
    include($refL_path_comp . "/referencelist.uploadimage.php");
    exit;
    break;

  default:
    listReference( $option );
    break;
}

function editReference( $id, $option ) {
  global $database, $my, $mosConfig_absolute_path;

  $row = new referencelist( $database );
  // load the row from the db table
  $row->load( $id );

  // fail if checked out not by 'me'
  if ($row->checked_out && $row->checked_out <> $my->id) {
    mosRedirect( "index2.php?option=$option",
      'The module $row->name is currently being edited by another administrator.' );
  }

  if ($id) {
    // do stuff for existing records
      $row->checkout( $my->id );
  } else {
    // do stuff for new records
    $row->ordering = 999;
  }

  if ($id) {
    // build the html select list for ordering
    $order = mosGetOrderingList( "SELECT ordering AS value, name AS text"
      . "\nFROM #__referencelist"
      . "\nWHERE published >= 0 ORDER BY ordering"
    );
    $olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
    'value', 'text', intval( $row->ordering ) );
  } else {
    $olist = "<input type=\"hidden\" name=\"ordering\" value=\"$row->ordering\" />"
    . _REFL_NEW_ITEMS_LAST;
  }

  HTML_referencelist::editReferencelist( $row, $imagelist, $option, $olist );
}

function saveReference( $option ) {
  global $database, $my;

  $row = new referencelist( $database );
  if (!$row->bind( $_POST )) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  // pre-save checks
  if (!$row->check()) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  // save the changes
  if (!$row->store()) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }
  $row->checkin();
  $row->updateOrder();

  mosRedirect( "index2.php?option=$option" );
}

function addReferenceImages( $ref_id, $option) {
  global $database, $my;

  $row = new referenceImages( $database );
  if (!$ref_id) {
    echo "<script> alert('Keine Referenz-ID &uuml;bergeben'); window.history.go(-1); </script>\n";
    exit();
  }
  $row->ref_id = $ref_id;
  $row->published = '1';

  if (!$row->bind( $_POST )) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  // pre-save checks
  if (!$row->check()) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  // save the changes
  if (!$row->store()) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  $row->updateOrder();

  mosRedirect( "index2.php?option=$option&task=listImages&pid[]=".$ref_id );
}

/**
* Cancels an edit operation
* @param string The current url option
*/
function cancelReference( $option ) {
  global $database;
  $row = new referencelist( $database );
  $row->bind( $_POST );
  $row->checkin();
  mosRedirect( "index2.php?option=$option" );
}

/**
* Delete a Reference
*/
function removeReference( $pid, $option ) {
  global $database;

  if (!is_array( $pid ) || count( $pid ) < 1) {
    echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
    exit;
  }
  if (count( $pid )) {
    $pids = implode( ',', $pid );
    $database->setQuery( "DELETE FROM #__referencelist WHERE id IN ($pids)" );
    if (!$database->query()) {
      echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }
  }

  mosRedirect( "index2.php?option=$option" );
}

/**
* Change the state publish / unpublish of a Reference
*/
function changeReference(  $pid=null, $state=0, $option ) {
  global $database, $my;

  if (count( $pid ) < 1) {
    $action = $publish == 1 ? 'publish' : 'unpublish';
    echo "<script> alert('Select a record to $action'); window.history.go(-1);</script>\n";
    exit;
  }

  $pids = implode( ',', $pid );

  $database->setQuery( "UPDATE #__referencelist SET published='$state'"
  . "\nWHERE id IN ($pids) AND (checked_out=0 OR (checked_out='$my->id'))"
  );
  if (!$database->query()) {
    echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    exit();
  }

  if (count( $pid ) == 1) {
    $row = new referencelist( $database );
    $row->checkin( intval( $pid[0] ) );
  }

  mosRedirect( "index2.php?option=$option" );
}

/**
* Change the state publish / unpublish of a ReferenceImage
*/
function changeReferenceImages( $pid=null, $ref_id, $state=0, $option ) {
  global $database, $my;

  if (count( $pid ) < 1) {
    $action = $publish == 1 ? 'publish' : 'unpublish';
    echo "<script> alert('Select a record to $action'); window.history.go(-1);</script>\n";
    exit;
  }

  $pids = implode( ',', $pid );

  $database->setQuery( "UPDATE #__referencelist_img SET published='$state'"
  . "\nWHERE id IN ($pids)"
  );
  if (!$database->query()) {
    echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    exit();
  }

  mosRedirect( "index2.php?option=$option&task=listImages&pid[]=".$ref_id );
}

/**
* Change the order of a Reference
*/
function orderReference( $pid, $inc, $option ) {
  global $database;
  $row = new referencelist( $database );
  $row->load( $pid );
  $row->move( $inc, "published >= 0" );

  mosRedirect( "index2.php?option=$option" );
}

/**
* Change the order of a ReferenceImage
*/
function orderReferenceImages( $pid, $ref_id, $inc, $option ) {
  global $database;
  $row = new referenceImages( $database );
  $row->load( $pid );
  $row->move( $inc, "published >= 0" );

  mosRedirect( "index2.php?option=$option&task=listImages&pid[]=".$ref_id );
}

/**
* List the References in the Overview
*/
function listReference( $option ) {
  global $mainframe, $database;

  $limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
  $limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
  $search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
  $search = $database->getEscaped( trim( strtolower( $search ) ) );
  $where = $search ? " WHERE p.name LIKE '%" . $search . "%' OR p.description LIKE '%" . $search . "%'" : "";

  // get the total number of records
  $database->setQuery( "SELECT COUNT(*) FROM #__referencelist $where" );
  $total = $database->loadResult();

  require_once( "includes/pageNavigation.php" );
  $pageNav = new mosPageNav( $total, $limitstart, $limit  );

  $q_raw = "SELECT p.*, u.name AS editor"
    . "\nFROM #__referencelist AS p"
    . "\nLEFT JOIN #__users AS u ON u.id = p.checked_out"
    . "\n" . $where
    . "\nORDER BY ordering, name ASC"
    . "\nLIMIT $pageNav->limitstart, $pageNav->limit";
  $database->setQuery( $q_raw );
  $rows = $database->loadObjectList();

  echo '<p class="error">' . $database->getErrorMsg() . '</p>';

  HTML_referencelist::displayList( $rows, $pageNav, $search, $option );
}

/**
* List the ReferencesImages in the Overview
*/
function listReferenceImages( $id, $option ) {
  global $mainframe, $database, $mosConfig_absolute_path, $refConf;
  $refConf = new referenceConfig( $database );
  $refConf->loadAll();

  $limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
  $limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

  // get the total number of records
  $database->setQuery( "SELECT COUNT(*) FROM #__referencelist_img WHERE ref_id=$id" );
  $total = $database->loadResult();

  require_once( "includes/pageNavigation.php" );
  $pageNav = new mosPageNav( $total, $limitstart, $limit  );

  // create image-selection
  $imageFiles = mosReadDirectory( $mosConfig_absolute_path . "/images/stories/reference" );
  $images = array(  mosHTML::makeOption( '', _REFL_SELECT_IMAGE ) );
  foreach ($imageFiles as $file) {
    if (eregi( "bmp|gif|jpg|png", $file )) {
      $images[] = mosHTML::makeOption( $file );
    }
  }

  $imagelist = mosHTML::selectList( $images,
                                    'ref_img_name',
                                    "class=\"inputbox\" size=\"1\" onchange=\"javascript:if (document.forms[0].ref_img_name.options[selectedIndex].value!='') {document.imagelib.src='../images/stories/reference/' + document.forms[0].ref_img_name.options[selectedIndex].value} else {document.imagelib.src='../images/M_images/blank.png'}\"",
                                    'value',
                                    'text' );

  // create thumbnail-selection if necessary
  if ($refConf->cfg["show_thumbs"] == "1") {
    $t_imageFiles = mosReadDirectory( $mosConfig_absolute_path . "/images/stories/reference" );
    $t_images = array(  mosHTML::makeOption( '', _REFL_SELECT_THUMBNAIL ) );
    foreach ($t_imageFiles as $t_file) {
      if (eregi( "bmp|gif|jpg|png", $t_file )) {
        $t_images[] = mosHTML::makeOption( $t_file );
      }
    }

    $t_imagelist = mosHTML::selectList( $t_images,
                                      'ref_thumb_name',
                                      "class=\"inputbox\" size=\"1\" onchange=\"javascript:if (document.forms[0].ref_thumb_name.options[selectedIndex].value!='') {document.t_imagelib.src='../images/stories/reference/' + document.forms[0].ref_thumb_name.options[selectedIndex].value} else {document.t_imagelib.src='../images/M_images/blank.png'}\"",
                                      'value',
                                      'text' );
  }
  else {
    $t_imagelist = '';
  }

  // get all images from database for this reference
  $q_raw = "SELECT *"
    . "\nFROM #__referencelist_img"
    . "\nWHERE ref_id = $id"
    . "\nORDER BY ordering, ref_img_name ASC"
    . "\nLIMIT $pageNav->limitstart, $pageNav->limit";
  $database->setQuery( $q_raw );
  $rows = $database->loadObjectList();
  echo '<p class="error">' . $database->getErrorMsg() . '</p>';

  HTML_referencelist::displayImgList( $rows, $id, $imagelist, $t_imagelist, $pageNav, $option );
}

/**
* Remove the ReferencImages
*/
function removeReferenceImages( $pid, $id, $option ) {
  global $database;

  if (!is_array( $pid ) || count( $pid ) < 1) {
    echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
    exit;
  }
  if (count( $pid )) {
    $pids = implode( ',', $pid );
    $database->setQuery( "DELETE FROM #__referencelist_img WHERE id IN ($pids)" );
    if (!$database->query()) {
      echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }
  }

  mosRedirect( "index2.php?option=$option&task=listImages&pid[]=".$id );
}

/**
* Show the About-Page
*/
function showAbout( $option ) {
  HTML_referencelist::showAboutScreen( $option );
}

/**
* Show the Config-Page
*/
function showConfig( $option ) {
  global $database;
  $refL = new referenceConfig( $database );
  $rows = $refL->loadAdminConf();
  HTML_referencelist::displayConfig( $rows, $option );
}

/**
* Save the Config-Values
*/
function saveConfig( $option ) {
  global $database, $my;

  $input_arr = array();
  $row = new referenceConfig( $database );

  foreach($_POST as $key => $val) {
    if (false !== strpos($key, "input_")) {
      $field = substr($key, 6);
      $row->cfg_name = $field;
      $row->cfg_value = (is_array($val) ? $val[0] : $val );

      if (!$row->check()) {
        echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
        exit();
      }
      if (!$row->store()) {
        echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
        exit();
      }

      $row->updateOrder();
    }
  }

  mosRedirect( "index2.php?option=$option" );
}
?>