<?php
/*****************************************************************
**         Zeltru-Design ReferenceList                          **
**                                                              **
**     (c) Copyright 2004-2005 by Zeltru-Design Zeljko Trulec   **
**         http://www.zeltru-design.de                          **
**         created @ August 2004                                **
**         last change @ August 2005                            **
**                                                              **
**         @ Released under GNU/GPL License:                    **
**         http://www.gnu.org/copyleft/gpl.html                 **
*****************************************************************/

if ( !function_exists("mosGetImg") ) {
  //****************************************************
  // Druckt den Bildstring aus!
  // Copyright by Zeltru-Design Z. Trulec
  function mosGetImg($image, $alt="", $w=0, $h=0, $more="") {
    global $mainframe, $mosConfig_templates, $mosConfig_absolute_path, $mosConfig_live_site;
    
    $local_file = $mosConfig_absolute_path . '/templates/' . $mainframe->getTemplate() . '/images/' . $image;
    if (file_exists($local_file)) {
      $image = '/templates/' . $mainframe->getTemplate() . '/images/' . $image;
    }
    if ($alt=="just_path") return $mosConfig_live_site . $image;
    if (file_exists($mosConfig_absolute_path . $image)) {
      $IMG = getimagesize($mosConfig_absolute_path . $image);
      if ($w && !$h) {
        $faktor = $IMG[0] / $w;
        $IMG[1] = $IMG[1] / $faktor;
      }
      $ret = '<img src="' . $mosConfig_live_site . $image . '" ';
      if ($w) {
        $ret .= 'width="' . $w . '" ';
      }
      else {
        $ret .= 'width="' . $IMG[0] . '" ';
      }
      if ($h) {
        $ret .= 'height="' . $h . '" ';
      }
      else {
        $ret .= 'height="' . $IMG[1] . '" ';
      }
      if ($alt) {
        $ret .= 'alt="' . $alt . '" border="0"';
      } else {
        $ret .= 'border="0"';
      }
      if ($more) {
        $ret .= ' ' . $more. '>';
      } else {
        $ret .= '>';
      }
      return $ret;
    }
    else return '<a nohref title="' . $image . ' / ' . $this->doc_root.$image . '">0</a>';
  }
}

if ( !function_exists("mosGetSpacer") ) {
  //****************************************************
  //Druckt den Bildstring aus!
  function mosGetSpacer($w=1, $h=1, $image='/images/M_images/blank.png') {
    global $mainframe, $mosConfig_templates, $mosConfig_absolute_path, $mosConfig_live_site;
    
    $localfile = $mosConfig_absolute_path . $image;
    if (!file_exists($localfile)) {
      return '<a nohref title="' . $mosConfig_absolute_path . $image . ' -/- ' . $mosConfig_live_site . $image . '">0</a>';
    }
    if (file_exists($mosConfig_absolute_path . $image)) {
      $ret = '<img src="' . $mosConfig_live_site . $image . '" ';
      $ret .= 'width="' . $w . '" ';
      $ret .= 'height="' . $h . '" ';
      $ret .= 'alt="" ';
      $ret .= 'border="0"';
      $ret .= '>';
      return $ret;
    }
    else return '<a nohref title="' . $mosConfig_absolute_path . $image . ' / ' . $mosConfig_live_site . $image . '">0</a>';
  }
}
?>