<?php

function sort_url($sorting_field,$action){
  return '<small>[<a style="color: black;" href="'.$_SERVER['PHP_SELF'].'?action='.$action.'&sorting_field='.$sorting_field.'&sort_order=ASC">^</a>|
                  <a style="color: black;" href="'.$_SERVER['PHP_SELF'].'?action='.$action.'&sorting_field='.$sorting_field.'&sort_order=DESC">v</a>]</small>';
}


function make_form($form_def,$form_layout,$form_felder,$form_data,$unique_data_field){
  if(count($form_data) == 0){ return("<br/>Keine Daten vorhanden.<br/>"); }

  $rowtag = 'even';
  $col_names_rep = 0;

  $vars[] = '{SUBMIT}';
  $values[] = make_form_submit($form_def[4]);
  $form_layout["footer"] = str_replace($vars, $values, $form_layout["footer"]);

  foreach ($form_felder as $name => $defs){
    $vars[] = '{'.$name.'}';
    $values[] = ($form_felder[$name][2] ? $form_felder[$name][3].sort_url($name) : $form_felder[$name][3]);
  }
  $form_layout["col_names"] = str_replace($vars, $values, $form_layout["col_names"]);

  foreach ($form_data as $id => $data){
    if($rowtag == 'even'){ $rowtag = 'odd';}
    elseif($rowtag == 'odd'){ $rowtag = 'even';}
    $vars = array('{ROWTAG}');
    $values = array(' class="'.$rowtag.'" ');
    foreach ($form_felder as $name => $defs){
      $vars[] = '{'.$name.'}';
      $values[] = make_form_field($defs[0],$data[$id.$name]);
    }
    $all_loops[] = str_replace($vars, $values, $form_layout["loop"]);
    if(++$col_names_rep == 10){ 
      $all_loops[] = $form_layout["col_names"]; 
      $col_names_rep = 0;
    }
  }

  $form_layout["loop"] = implode("\n\n",$all_loops);
  return(make_form_form($form_layout,$form_def[0],$form_def[1],$form_def[2],$form_def[3]));
  }
		   
// TODO: ganz auf call_user_func... umstellen 
// Alex Rose, 24. Jan 2007, 20:31
function make_form_field($form_field,$form_data){
  $ret = "";

  if(is_array($form_field[0])){
    list($form_data,$form_field) = call_user_func($form_field[0][0], $form_data, 
						  array_slice($form_field[0],1));
  }
    
  switch($form_field[0]){
  case "plain":
    $ret = make_form_plain($form_data[0]);
    break;
  case "textfield":
    $ret = make_form_textfield($form_data[0],$form_data[1],$form_field[1]);
    break;
  case "submit":
    $ret = make_form_submit($form_data[0]);
    break;
  case "hidden":
    $ret = make_form_hidden($form_data[0],$form_data[1]);
    break;
  case "checkbox":
    $ret = call_user_func_array('make_form_checkbox',array_merge($form_data,array_slice($form_field,1)));
    break;
  case "select":
    $ret = make_form_select($form_data[0],$form_data[1],$form_field[1],$form_field[2]);
    break;
  case "radio":
    $ret = call_user_func_array('make_form_radio',array_merge($form_data,array_slice($form_field,1)));
    break;
  default:
  }  
  return($ret);
}
	
// Parameter: form name, form method, form action, 
// creates a hidden field with array(value, name),
// name des formular buttons	   
function make_form_form($value,$id,$method,$action,$hidden_field){
  return('<form name="form" action="'.$action.'" method="'.$method.'">'.
	 make_form_hidden($hidden_field[0],$hidden_field[1]).
	 implode("\n\n",$value).'</form>');
}

function make_form_hidden($value,$id){
  return('<input type="hidden" name="'.$id.'" value="'.$value.'">');
}

function make_form_checkbox($checked_value,$id,$value,$default_value=0){
  if($value == $checked_value){$checked = ' checked';}else{$checked = '';};
  return(make_form_hidden($default_value,$id).'<input type="checkbox" name="'.$id.'" value="'.$value.'"'.$checked.'/>');
}

function make_form_radio($checked_value,$id,$values){
  $radios = array();
  foreach($values as $value){
    // list($value, $name, $disabled, $readonly) = $value;
    // does list(...) work when #var differs? Alex Rose, 24. Jan 2007, 21:24
    if(isset($value[2]) AND $value[2] === TRUE){$disabled='disabled ';
    }else{$disabled='';}
    if(isset($value[3]) AND $value[3] === TRUE){$readonly='readonly ';
    }else{$readonly='';}

    if($value[0] == $checked_value){$checked = 'checked';}else{$checked = '';}

    $radios[] = $value[1].':<input '.$readonly.$disabled.'type="radio" name="'.$id.'" value="'.$value[0].'" '.$checked.'>';
  }
  return(implode('</br>',$radios));
}

function make_form_option($value,$selected=FALSE){
  if($selected){$selected = ' selected';}else{$selected = '';};
  return('<option'.$selected.'>'.$value.'</option>');
}

function make_form_select($selected_value,$id,$size,$values){
  $opts = array();
  foreach($values as $value){
    if($value == $selected_value){$selected = TRUE;}else{$selected = FALSE;}
    $opts[] = make_form_option($value,$selected);
  }
  return('<select name="'.$id.'" size="'.$size.'">'.implode("",$opts).'</select>');
}

function make_form_plain($value){
  return($value);
}

function make_form_textfield($value,$id,$maxlength){
  return('<input type="text" name="'.$id.'" id="'.$id.'" maxlength="'.$maxlength.'" value="'.$value.'" class="textfield">');
}

// <form name="form" action="/web/scripts/attaccms/test/pages/alextest.php" method="post">

function make_form_submit($value,$id='submit'){
  return('<input type="submit" name="'.$id.'" value="'.$value.'">');
}

?>
