<?php
//generiert QR-Rechnung
use Sprain\SwissQrBill as QrBill;

require __DIR__ . '/../../vendor/autoload.php';

$qrBill = QrBill\QrBill::create();

//Kreditoren Informationen eintragen (Wer erhält das Geld?)
$qrBill->setCreditor(
    QrBill\DataGroup\Element\CombinedAddress::create(
        "vor nachname",
        "adresse nr",
        "plz ort",
        'CH'
    ));

$qrBill->setCreditorInformation(
    QrBill\DataGroup\Element\CreditorInformation::create(
        'IBAN' // Hier muss die spezielle IBAN Nummer eingetragen werden
    ));
    
    
    //Debitor, Rechnungsempfänger Adresse
$qrBill->setUltimateDebtor(
    QrBill\DataGroup\Element\CombinedAddress::create(
        "vor nachname",
        "adresse nr",
        "plz ort",
        'CH'
    ));


$qrBill->setPaymentAmountInformation(
    QrBill\DataGroup\Element\PaymentAmountInformation::create(
        'CHF',
        100.00 //Der zuzahlende Betrag in Franken
    ));
    
    $referenceNumber = QrBill\Reference\QrPaymentReferenceGenerator::generate(
    '826372',  // fix definierte Nummer, kann von der Bank bezogen werden
    '00000000000000000001' // individuelle Nummer um die Bestellung eindeutig seinen Auftragsdaten zuzuordnen z.b. AuftragsId.
);

$qrBill->setPaymentReference(
    QrBill\DataGroup\Element\PaymentReference::create(
        QrBill\DataGroup\Element\PaymentReference::TYPE_QR,
        $referenceNumber
    ));
    
 //Nur QR-Code als Bild
try {
    $qrBill->getQrCode()->writeFile(__DIR__ . '/qr.png');
    $qrBill->getQrCode()->writeFile(__DIR__ . '/qr.svg');
} catch (Exception $e) {
	foreach($qrBill->getViolations() as $violation) {
		print $violation->getMessage()."\n";
	}
	exit;
}

// … oder gleich das ganze Rechnungsdokument als PDF
$output = new QrBill\PaymentPart\Output\HtmlOutput\HtmlOutput($qrBill, 'de');

print $output
    ->setPrintable(false)
    ->setQrCodeImageFormat(QrBill\QrCode\QrCode::FILE_FORMAT_SVG)
    ->getPaymentPart();
//pdf html
$rechnungs_nummer = "743";
$rechnungs_datum = date("d.m.Y");
$lieferdatum = date("d.m.Y");
$pdfAuthor = "toem";

$rechnungs_header = '
<img src="header_logo.png" width="75" height="75">
firma adresse';

$rechnungs_empfaenger = 'kunde adresse';

$rechnungs_footer = "Wir bitten um eine Begleichung der Rechnung innerhalb von 14 Tagen nach Erhalt. Bitte Überweisen Sie den vollständigen Betrag an:

<b>Empfänger:</b> firma
<b>IBAN</b>: iban";

//Auflistung eurer verschiedenen Posten im Format [Produktbezeichnung, Menge, Einzelpreis]
$rechnungs_posten = array(
	array("Produkt 1", 1, 42.50),
	array("Produkt 2", 5, 5.20),
	array("Produkt 3", 3, 10.00));

//Höhe eurer Umsatzsteuer. 0.19 für 19% Umsatzsteuer
$umsatzsteuer = 0.0; 



//////////////////////////// Inhalt des PDFs als HTML-Code \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\


// Erstellung des HTML-Codes. Dieser HTML-Code definiert das Aussehen eures PDFs.
// tcpdf unterstützt recht viele HTML-Befehle. Die Nutzung von CSS ist allerdings
// stark eingeschränkt.

$html = '
<table cellpadding="5" cellspacing="0" style="width: 100%; ">
	<tr>
		<td>'.trim($rechnungs_header).'</td>
	   <td style="text-align: right">
Rechnungsnummer '.$rechnungs_nummer.'<br>
Rechnungsdatum: '.$rechnungs_datum.'<br>
Lieferdatum: '.$lieferdatum.'<br>
		</td>
	</tr>

	<tr>
		 <td style="font-size:1.3em; font-weight: bold;">
<br><br>
Rechnung
<br>
		 </td>
	</tr>


	<tr>
		<td colspan="2">'.trim($rechnungs_empfaenger).'</td>
	</tr>
</table>
<br><br><br>

<table cellpadding="5" cellspacing="0" style="width: 100%;" border="0">
	<tr style="background-color: #cccccc; padding:5px;">
		<td style="padding:5px;"><b>Bezeichnung</b></td>
		<td style="text-align: center;"><b>Menge</b></td>
		<td style="text-align: center;"><b>Einzelpreis</b></td>
		<td style="text-align: center;"><b>Preis</b></td>
	</tr>';
			
	
$gesamtpreis = 0;

foreach($rechnungs_posten as $posten) {
	$menge = $posten[1];
	$einzelpreis = $posten[2];
	$preis = $menge*$einzelpreis;
	$gesamtpreis += $preis;
	$html .= '<tr>
                <td>'.$posten[0].'</td>
				<td style="text-align: center;">'.$posten[1].'</td>		
				<td style="text-align: center;">'.number_format($posten[2], 2, '.', '').' CHF</td>	
                <td style="text-align: center;">'.number_format($preis, 2, '.', '').' CHF</td>
              </tr>';
}
$html .="</table>";



$html .= '
<hr>
<table cellpadding="5" cellspacing="0" style="width: 100%;" border="0">';
if($umsatzsteuer > 0) {
	$netto = $gesamtpreis / (1+$umsatzsteuer);
	$umsatzsteuer_betrag = $gesamtpreis - $netto;
	
	$html .= '
			<tr>
				<td colspan="3">Zwischensumme (Netto)</td>
				<td style="text-align: center;">'.number_format($netto , 2, '.', '').' CHF</td>
			</tr>
			<tr>
				<td colspan="3">Umsatzsteuer ('.intval($umsatzsteuer*100).'%)</td>
				<td style="text-align: center;">'.number_format($umsatzsteuer_betrag, 2, '.', '').' CHF</td>
			</tr>';
}

$html .='
            <tr>
                <td colspan="3"><b>Gesamtsumme: </b></td>
                <td style="text-align: center;"><b>'.number_format($gesamtpreis, 2, '.', '').' CHF</b></td>
            </tr>			
        </table>
<br><br><br>
<tr>';


if($umsatzsteuer == 0) {
 $html .= 'Wir sind nicht MwSt.-Pflichtig';
}
 
// 2. Create a TCPDF instance (or use an existing one from your project)
$tcPdf = new TCPDF('P', 'mm', 'A4', true, 'ISO-8859-1');

$tcPdf->setPrintHeader(false);
$tcPdf->setPrintFooter(false);
$tcPdf->SetAutoPageBreak(true,0);
$tcPdf->AddPage();

$tcPdf->writeHTML($html, true, false, true, false, '');
$tcPdf->AddPage();
// 3. Create a full payment part for TcPDF
$output = new QrBill\PaymentPart\Output\TcPdfOutput\TcPdfOutput($qrBill, 'de', $tcPdf);
$output
    ->setPrintable(false)
    ->getPaymentPart();
$t=time();


// 4. For demo purposes, let's save the generated example in a file
$examplePath = __DIR__ . "/QR-Rechnung.pdf";
$tcPdf->Output($examplePath, 'F');


//email mit rechnung senden

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

date_default_timezone_set('Etc/UTC');

require 'src/PHPMailer.php';
require 'src/SMTP.php';

$mail = new PHPMailer;

$mail->isSMTP();
//Enable SMTP debugging
// 0 = off (for production use)
// 1 = client messages
// 2 = client and server messages
$mail->SMTPDebug = 0;
//Ask for HTML-friendly debug output
$mail->Debugoutput = 'html';
//Set the hostname of the mail server
$mail->Host = "host";
//Set the SMTP port number - likely to be 25, 465 or 587
$mail->Port = 25;
//Whether to use SMTP authentication
$mail->SMTPAuth = true;
//Username to use for SMTP authentication
$mail->Username = "mail";
//Password to use for SMTP authentication
$mail->Password = "pw";
//Set who the message is to be sent from
$mail->setFrom('mail', 'name');
//Set an alternative reply-to address
$mail->addReplyTo('mail', 'name');
//Set who the message is to be sent to
$mail->addAddress('mail', 'John Doe');
//Provide file path and name of the attachments
$mail->addAttachment($examplePath, "Rechnung_743.pdf");        


$mail->isHTML(true);

$mail->Subject = "Auftrag + QR-Rechnung [name]";
$mail->Body = "<i>Lieber Kunde, vielen Dank fuer die Bestellung! <br>Anbei senden wir Ihnen den Auftrag inkl. QR-Rechnungsteil.<br> Bei Fragen wenden Sie sich bitte als Antwort auf diese E-Mail an uns.<br><br> Gruss FIRMA</i>";
$mail->AltBody = "This is the plain text version of the email content";
$mail->send();